% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bls_overview.R
\name{bls_overview}
\alias{bls_overview}
\title{Display BLS Dataset Overview}
\usage{
bls_overview(
  series_id,
  display_method = "viewer",
  base_url = "https://download.bls.gov/pub/time.series"
)
}
\arguments{
\item{series_id}{Character string. The BLS series identifier (e.g., "ln", "cu", "ap")}

\item{display_method}{Character string. How to display the overview: 
"viewer" (default), "console", or "popup"}

\item{base_url}{Character string. Base URL for BLS data (default uses official BLS site)}
}
\value{
Invisibly returns the text content. Function is called to use the viewer, console, or as a popup, depending on the 'display_method' argument.
}
\description{
Fetches and displays the overview text file for a BLS dataset. This provides a convenient reference within the R environment without needing to manually find and review the text file on the BLS website.
}
\examples{
\donttest{
# Display labor force statistics overview
bls_overview("ln")

# Display consumer price index overview  
bls_overview("cu")

# Display in console instead of viewer
bls_overview("ln", display_method = "console")
}
}
