% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observationIndex.R
\name{logObsInd}
\alias{logObsInd}
\title{The actual observation index function}
\usage{
logObsInd(focal, group, fs.rm = TRUE, norm = TRUE)
}
\arguments{
\item{focal}{observations/visits for the focal species}

\item{group}{observations/visits for the reference species group}

\item{fs.rm}{if TRUE, assumes that the observations for the focal species are
included in 'group' and will remove them}

\item{norm}{if TRUE, the result is normalized to a 0-1 range}
}
\value{
a positive observation index
}
\description{
This function implements the algorithms to calculate the observation index.
OI = log ( (At / (At + Rt) ) / ( A / (A + R) ) )
where At is the sum of observations for focal species during time t (or grid),
Rt is sum of observations of all species in reference group during t,
A and R are the total sums for observations.
}
\references{
Telfer, Preston & Rothery (2002) <doi:10.1016/S0006-3207(02)00050-2>
}
\keyword{internal}
