% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctTaxo.R
\name{correctTaxo}
\alias{correctTaxo}
\title{Checking typos in names}
\usage{
correctTaxo(genus, species = NULL, score = 0.5, useCache = TRUE,
  verbose = TRUE)
}
\arguments{
\item{genus}{Vector of genera to be checked. Alternatively, the whole species name (genus + species)
or (genus + species + author) may be given (see example).}

\item{species}{(optional) Vector of species to be checked (same size as the genus vector).}

\item{score}{Score of the matching (see http://tnrs.iplantcollaborative.org/instructions.html#match) below which corrections are discarded.}

\item{useCache}{logical. Whether or not use a cache to reduce online search of taxa names (NULL means use cache but clear it first)}

\item{verbose}{logical. If TRUE various messages are displayed during process}
}
\value{
The function returns a dataframe with the corrected (or not) genera and species.
}
\description{
This function corrects typos for a given taxonomic name using the Taxonomic
Name Resolution Service (TNRS) via the Taxosaurus interface.
This function has been adapted from the \code{tnrs} function from the taxize package (\code{\link[taxize:tnrs]{taxize::tnrs()}}).
}
\details{
This function create a file named correctTaxo.log (see Localisation), this file have the memory of all the previous requests, as
to avoid the replication of time-consuming servor requests.

By default, names are queried in batches of 50, with a 0.5s delay between each query. These values can be modified using options:
\code{options(BIOMASS.batch_size=50)} for batch size, \code{options(BIOMASS.wait_delay=0.5)} for delay.
}
\section{Localisation}{

The localisation of the folder is :
\itemize{
\item On Linux : \code{~/.local/share/R/BIOMASS}
\item On Mac OS X : \code{~/Library/Application Support/R/BIOMASS}
\item On Windows 7 up to 10 : \code{C:\\Users\\<username>\\AppData\\Local\\R\\BIOMASS\\R\\BIOMASS}
\item On Windows XP : \code{C:\\Documents and Settings\\<username>\\Data\\R\\BIOMASS\\R\\BIOMASS}
}

See this function for more information : \code{\link[rappdirs:user_data_dir]{rappdirs::user_data_dir()}}
}

\examples{
\dontrun{
correctTaxo(genus = "Astrocarium", species = "standleanum")
correctTaxo(genus = "Astrocarium standleanum")
}

}
\references{
Boyle, B. et al. (2013).
\emph{The taxonomic name resolution service: An online tool for automated standardization of plant names}.
BMC bioinformatics, 14, 1.

Chamberlain, S. A. and Szocs, E. (2013). \emph{taxize: taxonomic search and retrieval in R}.
F1000Research, 2.
}
\author{
Ariane TANGUY, Arthur PERE, Maxime REJOU-MECHAIN, Guillaume CORNU
}
