% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitMarginals.R
\name{fitMarginals}
\alias{fitMarginals}
\title{Fit two 4-parameter log-logistic functions for a synergy experiment}
\usage{
fitMarginals(data, transforms = NULL, start = NULL, constraints = NULL,
  fixed = NULL, method = c("nlslm", "nls", "optim"), names = NULL, ...)
}
\arguments{
\item{data}{Dose-response dataframe. Marginal data will be extracted from
it automatically.}

\item{transforms}{Transformation functions. If non-null, \code{transforms} is
a list containing 5 elements, namely biological and power transformations
along with their inverse functions and \code{compositeArgs} which is a list
with argument values shared across the 4 functions. See vignette for more
information.}

\item{start}{Starting parameter values. If not specified, they will be
obtained from \code{\link{initialMarginal}}.}

\item{constraints}{List of constraint matrix and vector which will be passed
to \code{\link{constructFormula}}. If \code{constraints = NULL}, no
constraints on parameter estimation will be imposed.}

\item{fixed}{This arguments provides a user-friendly alternative to impose a
fixed value for marginal parameters. It must be a named vector with names
contained in \code{c("h1", "h2", "b", "m1", "m2", "e1", "e2")}. For
example, \code{fixed = c("m1" = 1, "h1" = 1)} will automatically generate
appropriate constraint matrix and vector to set the maximal response and
the Hill coefficient of the first compound to 1. If both \code{constraints}
and \code{fixed} arguments are passed, then only \code{fixed} will be used.}

\item{method}{Which estimation method should be used to obtain the estimates.
If \code{method = "nls"}, simple non-linear least squares
\code{\link[stats]{nls}} will be used. If \code{method = "nlslm"}
Levenberg-Marquardt non-linear least squares
\code{\link[minpack.lm]{nlsLM}} is used instead (default). If \code{method
= "optim"}, residual sum of squares will be minimized using general purpose
optimization based on Nelder-Mean algorithm in \code{\link[stats]{optim}}.
This method can be noticeably slower than the non-linear least squares
methods.}

\item{names}{Compound names to be used on the plot labels.}

\item{...}{Further arguments that are passed to the optimizer function, 
such as \code{lower} or \code{upper} (for the "nlslm" method), or 
\code{control}.}
}
\value{
This function returns a \code{MarginalFit} object with monotherapy
  coefficient estimates and diverse information regarding monotherapy
  estimation. \code{MarginalFit} object is essentially a list with
  appropriately named elements.

  Among these list elements, \code{"coef"} is a named vector with parameter
  estimates. \code{h1} and \code{h2} are Hill's slope coefficients for each
  of the compounds, \code{m1} and \code{m2} are their maximal response levels
  whereas \code{b} is the shared baseline. Lastly, \code{e1} and \code{e2}
  are log-transformed EC50 values.

  \code{"sigma"} is standard deviation of residuals for the estimated
  monotherapy model and \code{"df"} is the degrees of freedom for the
  residuals. \code{"vcov"} is the variance-covariance matrix of the estimated
  parameters.

  Return object also contains information regarding data, biological and
  power transformations used in this estimation as well as model construct
  and method of estimation.
}
\description{
This function uses dose-response data for two compounds and estimates
coefficients for monotherapy models of both of these compounds such that they
share a common baseline. Currently, these coefficients are estimated by
default using a non-linear least squares approximation. Although entire
dose-response data can be provided, estimation will subset the part of data
where at least one of the compounds is dosed at zero, i.e. on-axis data.
}
\details{
Model formula is specified as \code{effect ~ fn(h1, h2, ...)} where \code{fn}
is a hard-coded function which fits two 4-parameter log-logistic functions
simultaneously so that the baseline can be shared. If transformation
functions are provided, \code{fn} is consequently adjusted to account for
them.
}
\examples{
  data <- subset(directAntivirals, experiment == 1)
  ## Data must contain d1, d2 and effect columns
  transforms <- getTransformations(data)
  fitMarginals(data, transforms)
}
