% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotReponseSurface.R
\name{plotResponseSurface}
\alias{plotResponseSurface}
\title{Plot response surface}
\usage{
plotResponseSurface(data, fitResult = NULL,
  transforms = fitResult$transforms, predSurface = NULL,
  null_model = c("loewe", "hsa"), colorPalette = c("blue", "grey70", "red"),
  colorBy = "none", colorPoints = c("black", "sandybrown", "brown",
  "white"), breaks = c(-Inf, 0, Inf), radius = NULL, logScale = TRUE,
  colorfun = median, zTransform = function(x) x, add = FALSE, main = "",
  legend = TRUE, xat = "actual", yat = "actual", plotfun = NULL, ...)
}
\arguments{
\item{data}{Dose-response dataframe.}

\item{fitResult}{Monotherapy (on-axis) model fit, e.g. produced by
\code{\link{fitMarginals}}. It has to be a \code{"MarginalFit"} object or a
list containing \code{df}, \code{sigma}, \code{coef},
\code{shared_asymptote} and \code{method} elements for, respectively,
marginal model degrees of freedom, residual standard deviation, named
vector of coefficient estimates, logical value of whether shared asymptote
is imposed and method for estimating marginal models during bootstrapping
(see \code{\link{fitMarginals}}). If biological and power transformations
were used in marginal model estimation, \code{fitResult} should contain
\code{transforms} elements with these transformations. Alternatively, these
can also be specified via \code{transforms} argument.}

\item{transforms}{Transformation functions. If non-null, \code{transforms} is
a list containing 5 elements, namely biological and power transformations
along with their inverse functions and \code{compositeArgs} which is a list
with argument values shared across the 4 functions. See vignette for more
information.}

\item{predSurface}{Vector of all predicted responses based on
\code{expand.grid(uniqueDoses)}. If not supplied, it will be computed
with \code{\link{predictOffAxis}} function.}

\item{null_model}{If \code{predSurface} is not supplied, it is computed using
one of the available null models, i.e. \code{"loewe"} or \code{"hsa"}. See
also \code{\link{fitSurface}}.}

\item{colorPalette}{Vector of color names for surface}

\item{colorBy}{This parameter determines values on which coloring is based
for the 3-dimensional surface. If matrix or a data frame with \code{d1} and
{d2} columns is supplied, dose combinations from \code{colorBy} will be
matched automatically to the appropriate dose combinations in \code{data}.
Unmatched dose combinations will be set to 0. This is especially useful for
plotting results for off-axis estimates only, e.g. off-axis Z-scores or
maxR test statistics. If \code{colorBy = "colors"}, surface will be colored
using colors in \code{colorPalette} argument.}

\item{colorPoints}{Colors for off-axis and on-axis points. Character vector
of length four with colors for 1) off-axis points; 2) on-axis points of the
first drug (i.e. second drug is dosed at zero); 3) on-axis points of the
second drug; 4) on-axis points where both drugs are dosed at zero.}

\item{breaks}{Numeric vector with numerical breaks. To be used in conjunction
with \code{colorPalette} argument.}

\item{radius}{Radius of spheres. If missing, an educated guess based on
number of digits in average effect will be made.}

\item{logScale}{Draw doses on log-scale (setting zeroes to be finite constant)}

\item{colorfun}{If replicates in \code{colorBy} variable are present, these
will be aggregated using \code{colorfun} function. This can also be a
custom function returning a scalar.}

\item{zTransform}{Optional transformation function for z-axis. By default,
identity function is used.}

\item{add}{Add the predicted response surface to an existing plot. Will not
draw any points, just the surface. Must be called after another call to
\code{\link{plotResponseSurface}}.}

\item{main}{Fixed non-moving title for the 3D plot}

\item{legend}{Whether legend should be added}

\item{xat}{x-axis ticks: "pretty", "actual" or a numeric vector}

\item{yat}{y-axis ticks: "pretty", "actual" or a numeric vector}

\item{plotfun}{If replicates for dose combinations in \code{data} are
available, points can be aggregated using \code{plotfun} function.
Typically, it will be \code{\link{mean}}, \code{\link[stats]{median}},
\code{\link{min}} or \code{\link{max}} but a custom-defined function
returning a scalar from a vector is also possible.}

\item{...}{Further arguments to format axis labels}
}
\value{
Plot is shown on a rgl device.
}
\description{
Plot the 3-dimensional response surface predicted by one of the null
models. This plot allows for a visual comparison between the null
model prediction and observed points. This function is mainly used
as the workhorse of \code{\link{plot.ResponseSurface}} method.
}
\details{
Title for the plot and legend are drawn as bitmaps and do not rotate with the
rest of the plot. Since they are bitmaps, they do not scale properly, hence
resizing window will result in unappealing visuals. For them to look
properly, it suffices to set the appropriate RGL window size and rerun the
plotting command.
}
\examples{
\dontrun{
  data <- subset(directAntivirals, experiment == 1)
  ## Data must contain d1, d2 and effect columns
  fitResult <- fitMarginals(data)
  data_mean <- aggregate(effect ~ d1 + d2, data = data[, c("d1", "d2", "effect")],
                         FUN = mean)

  ## Construct the surface from marginal fit estimates based on HSA
  ## model and color it by mean effect level
  plotResponseSurface(data, fitResult, null_model = "hsa",
                      colorBy = data_mean, breaks = 10^(c(0, 3, 4, 6)),
                      colorPalette = c("grey", "blue", "green"))

  ## Response surface based on Loewe additivity model and colored with
  ## rainbow colors. Legend will not be displayed in any case.
  plotResponseSurface(data, fitResult, null_model = "loewe",
                      colorBy = "colors", colorPalette = rainbow(6))
}
}
