% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_belief_ggm.R
\name{prior_belief_ggm}
\alias{prior_belief_ggm}
\title{Prior Belief Gaussian Graphical Model}
\usage{
prior_belief_ggm(Y, prior_ggm, post_odds_cut = 3, ...)
}
\arguments{
\item{Y}{Matrix (or data frame) of dimensions \emph{n} (observations) by
\emph{p} (variables/nodes).}

\item{prior_ggm}{Matrix of dimensions \emph{p} by \emph{p}, encoding the prior
odds for including each relation in the graph (see '\code{Details}')}

\item{post_odds_cut}{Numeric. Threshold for including an edge (defaults to 3).
Note \code{post_odds} refers to posterior odds.}

\item{...}{Additional arguments passed to \code{\link{explore}}.}
}
\value{
An object including:

\itemize{

\item{\strong{adj}}: Adjacency matrix

\item{\strong{post_prob}}: Posterior probability for the
                           alternative hypothesis.

}
}
\description{
Incorporate prior information into the estimation of the
conditional dependence structure. This prior information is expressed as
the prior odds that each relation should be included in the graph.
}
\details{
Technically, the prior odds is not for including an edge in the graph,
but for (H1)/p(H0), where H1 captures the hypothesized edge size and H0 is the
null model  \insertCite{@see Williams2019_bf}{BGGM}. Accordingly, setting an
entry in \code{prior_ggm} to, say, 10, encodes a prior belief that H1 is 10 times
more likely than H0. Further, setting an entry in \code{prior_ggm} to 1 results
in equal prior odds (the default in \code{\link{select.explore}}).
}
\examples{
\donttest{
# Assume perfect prior information
# synthetic ggm
p <- 20
main <- gen_net()

# prior odds 10:1, assuming graph is known
prior_ggm <- ifelse(main$adj == 1, 10, 1)

# generate data
y <- MASS::mvrnorm(n = 200,
                   mu = rep(0, 20),
                   Sigma = main$cors)

# prior est
prior_est <- prior_belief_ggm(Y = y,
                              prior_ggm = prior_ggm,
                              progress = FALSE)

# check scores
BGGM:::performance(Estimate = prior_est$adj,
                   True = main$adj)

# default in BGGM
default_est <- select(explore(y, progress = FALSE))

# check scores
BGGM:::performance(Estimate = default_est$Adj_10,
                   True = main$adj)

}
}
