% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bggm_missing.R
\name{bggm_missing}
\alias{bggm_missing}
\title{GGM: Missing Data}
\usage{
bggm_missing(x, iter = 2000, method = "estimate", ...)
}
\arguments{
\item{x}{An object of class \code{mid} \code{\link[mice]{mice}}.}

\item{iter}{Number of iterations for each imputed dataset (posterior samples; defaults to 2000).}

\item{method}{Character string. Which method should be used (default set to \code{estimate})? The current
options are \code{"estimate"} and \code{"explore"}.}

\item{...}{Additional arguments passed to either
\code{\link{estimate}} or \code{\link{explore}}.}
}
\value{
An object of class \code{estimate} or \code{explore}.
}
\description{
Estimation and exploratory hypothesis testing with missing data.
}
\note{
Currently, \strong{BGGM} is compatible with the package \code{\link[mice]{mice}} for handling
      the missing data. This is accomplished by fitting a model for each imputed dataset
      (i.e., more than one to account for uncertainty in the imputation step) and then pooling
      the estimates.

      In a future version, an additional option will be added that allows for
      imputing the missing values during model fitting. This option will be incorporated directly into
      the \code{\link{estimate}} or \code{\link{explore}} functions, such that \code{bggm_missing} will
      always support missing data with \code{\link[mice]{mice}}.


\strong{Support}:

 There is limited support for missing data. As of version \code{2.0.0}, it is possible to
 determine the graphical structure with either  \code{\link{estimate}} or \code{\link{explore}}, in addition
 to plotting the graph with \code{\link{plot.select}}. All data types \emph{are} currently supported.

\strong{Memory Warning}:
 A model is fitted for each imputed dataset. This results in a potentially large object.
}
