% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.estimate.R
\name{predict.var_estimate}
\alias{predict.var_estimate}
\title{Model Predictions for \code{var_estimate} Objects}
\usage{
\method{predict}{var_estimate}(object, summary = TRUE, cred = 0.95, iter = NULL, progress = TRUE, ...)
}
\arguments{
\item{object}{object of class \code{var_estimate}}

\item{summary}{summarize the posterior samples (defaults to \code{TRUE}).}

\item{cred}{credible interval used for summarizing}

\item{iter}{number of posterior samples (defaults to all in the object).}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE}) ?}

\item{...}{Currently ignored}
}
\value{
The predicted values for each regression model.
}
\description{
Model Predictions for \code{var_estimate} Objects
}
\examples{
\donttest{
# data
Y <- subset(ifit, id == 1)[,-1]

# fit model with alias (var_estimate also works)
fit <- var_estimate(Y, progress = FALSE)

# fitted values
pred <- predict(fit, progress = FALSE)

# predicted values (1st outcome)
pred[,,1]

}
}
