% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{plot.metric}
\alias{plot.metric}
\title{Plot \code{metric} Objects}
\usage{
\method{plot}{metric}(
  x,
  type = "error_bar",
  cred = 0.95,
  alpha = 0.5,
  scale = 1,
  width = 0,
  size = 1,
  color = "blue",
  rope = 0.1,
  ...
)
}
\arguments{
\item{x}{object of class \code{metric}}

\item{type}{\code{"error_bar"} or \code{"ridgeline"}}

\item{cred}{credible interval}

\item{alpha}{transparency of tail region (\code{type = "ridgeline"})}

\item{scale}{overlap of densities (\code{type = "ridgeline"})}

\item{width}{width of error bar end (\code{type = "error_bar"})}

\item{size}{point size (\code{type = "error_bar"})}

\item{color}{point (\code{type = "error_bar"}) or
tail region (\code{type = "ridgeline"} ) color}

\item{rope}{region of practical equivalence (only for Bayes R2 difference)}

\item{...}{currently ignored}
}
\value{
\code{ggplot}
}
\description{
Plot \code{metric} Objects
}
\examples{
\donttest{
# data
Y <- subset(tas, gender == "M")[,-ncol(tas)]

# fit model
fit <- estimate(Y)

# posterior predictions
pred <- posterior_predict(fit, iter = 500,
                          summary = FALSE)

# prediction error
error <- mse(pred)

# plot
plot(error)
}
}
