% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF.var.R
\name{bartlett_test}
\alias{bartlett_test}
\alias{bartlett_test.default}
\title{Bartlett Test of Homogeneity of Variances}
\usage{
bartlett_test(x, g, ...)

\method{bartlett_test}{default}(x, g, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of
numeric data vectors representing the respective samples,
or fitted linear model objects (inheriting from class "lm").}

\item{g}{a vector or factor object giving the group for
the corresponding elements of x. Ignored if x is a list.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"bartlett_htest"} containing the following
components: \item{statistic}{Bartlett's K-squared test statistic.}
\item{parameter}{the degrees of freedom of the approximate chi-squared
distribution of the test statistic.}
\item{p.value}{the p-value of the test.} \item{conf.int}{a confidence
interval for the mean appropriate to the specified alternative hypothesis.}
\item{method}{the character string "Bartlett test of homogeneity of variances".}
\item{data.name}{a character string giving the names of the data.}
\item{vars}{the sample variances across groups (samples).}
\item{n}{the number of observations per group (sample)}
}
\description{
Performs Bartlett's test of the null that the
variances in each of the groups (samples) are the same.
}
\details{
\code{x} must be a numeric data vector, and \code{g}
must be a vector or factor object of the same length as \code{x}
giving the group for the corresponding elements of \code{x}.
}
\section{Bain t_test}{

In order to allow users to enjoy the functionality of bain with the familiar
stats-function \code{bartlett.test}, we have had to make minor changes to the
function \code{bartlett.test.default}. All rights to, and credit for, the
function \code{bartlett.test.default}
belong to the R Core Team, as indicated in the original license below.
We make no claims to copyright and incur no liability with regard to the
changes implemented in \code{bartlett_test}.

This the original copyright notice by the R core team:
File src/library/stats/R/bartlett_test.R
Part of the R package, https://www.R-project.org

Copyright (C) 1995-2015 The R Core Team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

A copy of the GNU General Public License is available at
https://www.R-project.org/Licenses/
}

\examples{
require(graphics)

plot(count ~ spray, data = InsectSprays)
bartlett_test(InsectSprays$count, InsectSprays$spray)

}
\references{
Bartlett, M. S. (1937). Properties of sufficiency
and statistical tests. Proceedings of the Royal Society of
London Series A 160, 268–282. DOI: 10.1098/rspa.1937.0109.
}
