% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BETS.dummy.R
\name{BETS.dummy}
\alias{BETS.dummy}
\title{Create a monthly or quarterly dummy}
\usage{
BETS.dummy(start = NULL, end = NULL, frequency = 12, year = NULL,
  month = NULL, quarter = NULL, date = NULL, from = NULL, to = NULL)
}
\arguments{
\item{start}{An \code{integer vector}. The period of the first observation. The first element of the \code{vector} specifies the year of the first observation, whereas the second, the month (for monthly dummies) or quarter (for quarterly dummies)}

\item{end}{An \code{integer vector}. The period of the last observation. The first element of the \code{vector} specifies the year of the last observation, whereas the second, the month (for monthly dummies) or quarter (for quarterly dummies)}

\item{frequency}{An \code{integer}. The frequency of the dummy, that is, the number of observations per unit of time. The defaulf is 12 (a monthly dummy).}

\item{year}{An \code{integer}, a \code{seq} or a \code{vector}. The years for which the dummy must be set to 1. All periods of these years will be set to 1.}

\item{month}{An \code{integer}, a \code{seq} or a \code{vector}. The months for which the dummy must be set to 1. These months will be set to 1 for all years.}

\item{quarter}{An \code{integer}, a \code{seq} or a \code{vector}. The quarters for which the dummy must be set to 1. The quarters will be set to 1 for all years.}

\item{date}{a \code{list}. The periods for which the dummy must be set to one. Periods must be represented as {integer vectors}, as described for \code{start} and \code{end}.}

\item{from}{An \code{integer vector} The starting period of a sequence of perids for which the dummy must be set to one. Periods must be represented as {integer vectors}, as described for \code{start} and \code{end}.}

\item{to}{The ending period of a sequence of perids for which the dummy must be set to one. Periods must be represented as {integer vectors}, as described for \code{start} and \code{end}.}
}
\value{
A monthly or a quarterly \code{ts} object.
}
\description{
Returns a monthly or quarterly dummy (a time series with only 0s and 1s).
}
\examples{

#1 from a specific date to another specific date
BETS.dummy(start = c(2000,1),end = c(2012,5),frequency = 12,from = c(2005,1),to = c(2006,12))


#Other options that may be helpful:

#over a month equal to 1
BETS.dummy(start = c(2000,1), end = c(2012,5), frequency = 12, month = c(5,12))

#Months equal to 1 only for some year
BETS.dummy(start = c(2000,1), end = c(2012,5), frequency = 12, month = 5, year = 2010)
BETS.dummy(start = c(2000,1), end = c(2012,5), frequency = 12, month = 8, year = 2002)

#Months equal to 1 only for some years
BETS.dummy(start = c(2000,1), end = c(2012,5), frequency = 12, month = 5, year = 2005:2007)
BETS.dummy(start = c(2000,1), end = c(2012,5), frequency = 12, month = 3, year = c(2005,2007))
BETS.dummy(start = c(2000,1), end = c(2012,5), frequency = 12, month = 5:6, year = c(2005,2007))

#specific dates
BETS.dummy(start = c(2000,1), end = c(2012,5), frequency = 12, date = list(c(2010,1)))
BETS.dummy(start = c(2000,1), end = c(2012,5), 
    freq = 12, date = list(c(2010,9), c(2011,1), c(2000,1)) )


}
\seealso{
\code{\link[stats]{ts}}, \code{\link[BETS]{BETS.dummy}}
}
