% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firstCommonUpstreamBe.R
\name{firstCommonUpstreamBe}
\alias{firstCommonUpstreamBe}
\title{First common upstream BE}
\usage{
firstCommonUpstreamBe(beList = listBe(), uniqueOrg = TRUE)
}
\arguments{
\item{beList}{a character vector containing BE}

\item{uniqueOrg}{a logical value indicating if as single organism is under
focus. If false "Gene" is returned.}
}
\description{
Returns the first common Biological Entity (BE) upstream a set of BE.
}
\details{
This function is used to identified the level at which different BE should be
compared. Peptides and transcripts should be compared at the level of
transcripts whereas transcripts and objects should be compared at the
level of genes. BE from different organism should be compared at the level
of genes using homologs.
}
\examples{
\dontrun{
firstCommonUpstreamBe(c("Object", "Transcript"))
firstCommonUpstreamBe(c("Peptide", "Transcript"))
firstCommonUpstreamBe(c("Peptide", "Transcript"), uniqueOrg=FALSE)
}

}
\seealso{
\link{listBe}
}
