% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_beam_plot.R
\name{prep_beam_plot}
\alias{prep_beam_plot}
\title{Prepare for BEAM plotting}
\usage{
prep_beam_plot(beam.data, beam.specs)
}
\arguments{
\item{beam.data}{Result of prep.beam.data}

\item{beam.specs}{A data.frame of strings with columns name, mtx, mdl (string with R model with mtx.row)}
}
\value{
An updated beam.specs object that includes the column "plot"
}
\description{
Add a "plot" column to beam.specs, which includes string of plot commands.
}
\examples{
data(clinf)
data(omicdat)
data(omicann)
data(setdat)
test.beam.data <- prep_beam_data(main.data=clinf, mtx.data=omicdat,
                                 mtx.anns=omicann, set.data=setdat,
                                 set.anns=NULL, n.boot=10, seed=123)
specs <- prep_beam_specs(beam.data=test.beam.data, endpts=c("MRD29", "EFS", "OS"),
                         firth=TRUE)
plot.specs <- prep_beam_plot(beam.data=test.beam.data, beam.specs=specs)
}
