library(testthat)
library(BCHM)

context("BCHM test")

nDat = c(15, 3, 12, 28, 29, 29, 26, 5, 2, 20) # total number of patients
xDat = c(2, 0, 1, 6, 7, 3, 5, 1, 0, 3)  # number of responses
alpha <- 1e-20 
d0 <- 0.05 


alpha1 = 50   
beta1 = 10  
tau2 <- 0.1  
phi1 <- 0.1  
deltaT <- 0.2  
thetaT <- 0.60   

res <- BCHM(nDat = nDat,
            xDat = xDat,
            alpha = alpha,
            d0 = d0,             
            alpha1 = alpha1, 
            beta1 = beta1,
            tau2 = tau2,
            phi1 = phi1, 
            deltaT = deltaT,
            thetaT = thetaT,
            burnIn = 100,
            MCIter = 2000,
            MCNum = 4000,
            seed = 1000
)
print(res$SMatrix)
print(res$Result)
col <- res$Result[,4]
#col <- 1:10

BCHMplot_cluster(res, col, pch=16)
BCHMplot_post_value(res, col, HPD = 0.8)
BCHMplot_post_dist(res, col, lty=1:length(nDat), lwd =3, xlim=c(0, 0.8))



