% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppoisBCD.R
\name{ppoisBCD}
\alias{ppoisBCD}
\title{Cumulative Distribution Function for a Bivariate Poisson Distribution via Conditional Specification}
\usage{
ppoisBCD(x, y, lambda1, lambda2, lambda3)
}
\arguments{
\item{x}{value at which the c.d.f. is evaluated}

\item{y}{value at which the c.d.f. is evaluated}

\item{lambda1}{rate parameter for \eqn{ X } that must be positive}

\item{lambda2}{rate parameter for \eqn{ Y } that must be positive}

\item{lambda3}{dependence parameter that must be (0, 1]}
}
\value{
The probability \eqn{ P(X \leq x, Y \leq y) }.
}
\description{
Computes the cumulative distribution function (c.d.f.) of a bivariate Poisson distribution (BPD) with conditional specification, as described by Ghosh, Marques, and Chakraborty (2021).
}
\examples{
# Compute P(X \le 1, Y \le 1) with lambda1 = 0.5, lambda2 = 0.5, lambda3 = 0.5
ppoisBCD(x = 1, y = 1, lambda1 = 0.5, lambda2 = 0.5, lambda3 = 0.5)

# Example with larger values
ppoisBCD(x = 2, y = 2, lambda1 = 1.0, lambda2 = 1.0, lambda3 = 0.8)

}
\references{
Ghosh, I., Marques, F., & Chakraborty, S. (2021). A new bivariate Poisson distribution via conditional specification: properties and applications. \emph{Journal of Applied Statistics}, 48(16), 3025-3047. \doi{10.1080/02664763.2020.1793307}
}
\seealso{
\code{\link{dpoisBCD}} \code{\link{rpoisBCD}}
}
