% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{standard}
\alias{standard}
\title{Standardize variables.}
\usage{
standard(trait, method = "standard", convert = NULL)
}
\arguments{
\item{trait}{A species x traits matrix or data.frame.}

\item{method}{One of "standard" (standardize to mean = 0 and sd = 1, i.e., use z-score), "range" (rescale with range 0-1), or "rank" (rescale with range 0-1 after ranking).}

\item{convert}{A vector of column numbers to be standardized. If NULL all will be standardized.}
}
\value{
A matrix with variables standardized.
}
\description{
Standardize (or normalize) variables in different ways.
}
\details{
Standardizing values allows to directly compare variables of interest with inherently different ranges, avoiding artificial distortions of distances between observations.
}
\examples{
trait = data.frame(body = c(20,40,60,30,10), beak = c(NA,4,6,3,1))
standard(trait)
standard(trait, method = "range")
standard(trait, method = "rank")
}
