% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{sim.tree}
\alias{sim.tree}
\title{Simulation of phylogenetic or functional tree.}
\usage{
sim.tree(s, m = 100)
}
\arguments{
\item{s}{number of species.}

\item{m}{a structural parameter defining the average difference between species. Default is 100. Lower numbers create trees dominated by increasingly similar species, higher numbers by increasingly dissimilar species.}
}
\value{
An hclust object.
}
\description{
Simulates a random tree.
}
\details{
A very simple tree based on random genes/traits.
}
\examples{
tree <- sim.tree(10)
plot(as.dendrogram(tree))
tree <- sim.tree(100,10)
plot(as.dendrogram(tree))
tree <- sim.tree(100,1000)
plot(as.dendrogram(tree))
}
