% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.build}
\alias{kernel.build}
\title{Build kernel hypervolumes.}
\usage{
kernel.build(
  comm,
  trait,
  method = "gaussian",
  abund = TRUE,
  axes = 0,
  convert = NULL,
  weight = NULL,
  ...
)
}
\arguments{
\item{comm}{A sites x species matrix, data.frame or vector, with incidence or abundance data about the species in the community.}

\item{trait}{A species x traits matrix or data.frame.}

\item{method}{Method for constructing the 'Hypervolume' object. One of "gaussian" (Gaussian kernel density estimation, default), "box" (box kernel density estimation), or "svm" (one-class support vector machine). See respective functions of the hypervolume R package for details.}

\item{abund}{A boolean (T/F) indicating whether abundance data should be used as weights in hypervolume construction. Only works if method = "gaussian".}

\item{axes}{If 0, no transformation of data is done.
If 0 < axes <= 1 a PCoA is done with Gower distances and as many axes as needed to achieve this proportion of variance explained are selected.
If axes > 1 these many axes are selected.}

\item{convert}{A vector of column numbers, usually categorical variables, to be converted to dummy variables. Only used if axes > 0.}

\item{weight}{A vector of column numbers with weights for each variable. Its length must be equal to the number of columns in trait. Only used if axes > 0.}

\item{...}{Further arguments to be passed to hypervolume::hypervolume.}
}
\value{
A 'Hypervolume' or 'HypervolumeList', representing the hypervolumes of each community.
}
\description{
Builds kernel density hypervolumes from trait data.
}
\details{
Hypervolumes can be constructed with the given data or data can be transformed using PCoA over Gower distances (Pavoine et al. 2009) after traits are dummyfied (if needed) and standardized (always).
Gower distance allows continuous, ordinal, categorical or binary variables, with possible weighting.
NAs are allowed as long as each pair of species has at least one trait value in common.
If convert is given the algorithm will convert these column numbers to dummy variables. Otherwise it will convert all columns with factors or characters as values.
Transformation of traits is recommended if (Carvalho & Cardoso, 2020):
1) Some traits are not continuous; or
2) Some traits are correlated.
}
\examples{
\dontrun{
comm = rbind(c(1,3,0,5,3), c(3,2,5,0,0))
colnames(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")
rownames(comm) = c("Site 1", "Site 2")

trait = data.frame(body = c(1,2,3,4,4), beak = c(1,5,4,1,2))
rownames(trait) = colnames(comm)

hv = kernel.build(comm[1,], trait)
plot(hv)
hvlist = kernel.build(comm, trait)
plot(hvlist)
hvlist = kernel.build(comm, trait, method = "box", axes = 2, weight = c(1,2))
plot(hvlist)
}
}
\references{
Carvalho, J.C. & Cardoso, P. (2020) Decomposing the causes for niche differentiation between species using hypervolumes. Frontiers in Ecology and Evolution, 8: 243.

Pavoine et al. (2009) On the challenge of treating various types of variables: application for improving the measurement of functional diversity. Oikos, 118: 391-402.
}
