% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{hull.build}
\alias{hull.build}
\title{Build convex hull hypervolumes.}
\usage{
hull.build(comm, trait)
}
\arguments{
\item{comm}{A sites x species matrix, data.frame or vector, with incidence data about the species in the community.}

\item{trait}{A trait matrix, often resulting from hyper.build.}
}
\value{
A 'convhulln' object or a list, representing the hypervolumes of each community.
}
\description{
Builds convex hull hypervolumes for each community from incidence and trait data.
}
\examples{
comm = rbind(c(1,3,0,5,3), c(3,2,5,0,0))
colnames(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")
rownames(comm) = c("Site 1", "Site 2")

trait = data.frame(body = c(1,2,3,4,4), beak = c(1,5,4,1,2))
rownames(trait) = colnames(comm)

distance = gower(trait)
trait = hyper.build(distance)

hv = hull.build(comm[1,], trait)
plot(hv)
hvlist = hull.build(comm, trait)
plot(hvlist[[1]])
plot(hvlist[[2]])
}
