% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{sim.sample}
\alias{sim.sample}
\title{Simulation of sampling from artificial communities.}
\usage{
sim.sample(comm, cells = 100, samples = 0)
}
\arguments{
\item{comm}{simulated community data from function sim.spatial.}

\item{cells}{number of cells to divide the simulated space into. Default is 100.}

\item{samples}{number of samples (cells) to randomly extract. Default is the number of cells (the entire community).}
}
\value{
A matrix of samples x species (values are abundance per species per sample).
}
\description{
Simulates a sampling process from artificial communities.
}
\details{
The space will be divided in both dimensions by sqrt(cells).

Function useful for simulating sampling processes from the results of sim.spatial.

May be used as direct input to other functions (e.g. alpha, alpha.accum, beta, beta.accum) to test the behavior of multiple descriptors and estimators.
}
\examples{
comm <- sim.spatial(1000, 10)
sim.sample(comm)
sim.sample(comm, cells = 10, samples = 5)
}

