BASS
================

[![License: GPL
v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![](https://img.shields.io/badge/devel%20version-1.2.1-purple.svg)](https://github.com/lanl/BASS)
[![](https://www.r-pkg.org/badges/version/BASS?color=orange)](https://cran.r-project.org/package=BASS)

<!-- README.md is generated from README.Rmd. Please edit that file -->

BASS is an R package for fitting Bayesian Adaptive Spline Surface models
[available on CRAN](https://CRAN.R-project.org/package=BASS) with a
development version [available on GitHub](https://github.com/lanl/BASS).

To install the development version, use

``` r
# install.packages("devtools")
devtools::install_github("lanl/BASS")
```

Examples of uses are in Francom et al. (2018) and Francom et al. (2019)
and explicit code examples are given in the [R package
vignette](https://CRAN.R-project.org/package=BASS/vignettes/).

# References

<div id="refs" class="references">

<div id="ref-francom2019inferring">

Francom, Devin, Bruno Sansó, Vera Bulaevskaya, Donald Lucas, and Matthew
Simpson. 2019. “Inferring Atmospheric Release Characteristics in a Large
Computer Experiment Using Bayesian Adaptive Splines.” *Journal of the
American Statistical Association*.
<https://doi.org/10.1080/01621459.2018.1562933>.

</div>

<div id="ref-francom2018sensitivity">

Francom, Devin, Bruno Sansó, Ana Kupresanin, and Gardar Johannesson.
2018. “Sensitivity analysis and emulation for functional data using
Bayesian adaptive splines.” *Statistica Sinica*.
<https://doi.org/10.5705/ss.202016.0130>.

</div>

</div>
