\name{LikelihoodHistory}
\alias{LikelihoodHistory}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Calculating and Plot the history of log-Likelihood value
}
\description{
This function is a supplementary function for calculating and ploting the history of log-Likelihood value for each iteration. This function is used for tracking the evolution of the MCMC chain obtained from functions \code{Networks.STD()} and \code{Networks.Fast()}
}
\usage{
LikelihoodHistory(Trace,pvalue,Status=FALSE,True.Node)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{Trace}{the trace (results of each iteration) generated by the functions \code{Networks.STD()} and \code{Networks.Fast()}.Please set as \code{Trace=total$trace} where \code{total} is the output of the two functions, \code{Networks.STD()} and \code{Networks.Fast()}}
  \item{pvalue}{a vector of p-values obtained from large scale statistical hypothesis testing. It should be the same vector which you set for the argument \code{pvalue} in functions \code{Networks.STD()} and \code{Networks.Fast()}}
  \item{Status}{a logical variable indicating whether you have the assumed true value. \code{TRUE} means you have the assumed true value for plotting and \code{FALSE}, otherwise. The default setting is \code{FALSE}}
  \item{True.Node}{a binary(0/1) vector providing the assumed information of each node. The length of vector should be equal to the length of the vector of \code{pvalue}}
%%     ~~Describe \code{x} here~~
}


\value{
a table indicating the history of the history of log-Likelihood value for each iteration
}
\references{
Yize Zhao, Jian Kang, Tianwei Yu (2014) A Bayesian nonparameteric model for selecting gene and gene subnetwork, Annals of Applied Statistics, in press. 

Zhou Lan, Jian Kang, Tianwei Yu, Yize Zhao, BANFF: an R package for network identifications via Bayesian nonparametric mixture models, working paper.
}
\author{
Zhou Lan, Jian Kang, Tianwei Yu and Yize Zhao


Department of Biostatistics and Bioinformatics, Emory University}

\note{
A plot describing  the history of the history of log-Likelihood value for each iteration will be outputed. If you set \code{Status} and \code{True.Node}, a red line indicates the log-Likelihood value of the assumed status of each node. 
}

%% ~Make other sections like Warning with \section{Warning }{....} ~


