% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_diagnostics.R
\name{paramtrace}
\alias{paramtrace}
\title{Trace plot for parameters from an angmcmc object}
\usage{
paramtrace(object, par.name, comp.label, chain.no, ...)
}
\arguments{
\item{object}{angular MCMC object.}

\item{par.name}{vector of names of parameters for which point estimates are to be computed.  If \code{NULL}, results for all parameters are provided.}

\item{comp.label}{vector of component labels (positive integers, e.g., \code{1, 2, ...}) for which point estimates are to be computed.
If \code{NULL}, results for all components are provided.}

\item{chain.no}{vector of chain numbers whose samples are to be be used.
in the estimation. By default all chains are used.}

\item{...}{unused}

\item{par}{parameter for which trace plot is to be created.}
}
\value{
Returns a single plot if a single \code{par} and a single \code{comp.label} is supplied.
Otherwise, a series of plots is produced.
}
\description{
Trace plot for parameters from an angmcmc object
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
# trace plot for kappa1 in component 1
paramtrace(fit.vmsin.20, "kappa1", 1)
# for kappa1 in all components
paramtrace(fit.vmsin.20, "kappa1")
# for all parameters in component 1
paramtrace(fit.vmsin.20, comp.label = 1)

}
