% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{latent_allocation}
\alias{latent_allocation}
\title{Finding latent allocation (component indicators) from an angmcmc object}
\usage{
latent_allocation(object, ...)
}
\arguments{
\item{object}{angular MCMC object.}

\item{...}{passed to \link{pointest} to estimate parameters.}
}
\value{
Returns a vector of length n, where n is the length (if univariate) or
number of rows (if bivariate) of the data used in original fit.
i-th entry of the output vector provides component label for the i-th data point.
}
\description{
Finding latent allocation (component indicators) from an angmcmc object
}
\details{
In order to find the latent component indicators, estimates
of mixing proportions and model parameters are first computed via
pointest. Then, a data point is assigned label j, if the j-th
component gives highest density for that point.
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
# now find latent allocation
latent_allocation(fit.vmsin.20)
}
