% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{add_burnin_thin}
\alias{add_burnin_thin}
\title{Add (extra) burnin and thin to angmcmc object after original run}
\usage{
add_burnin_thin(object, burnin.prop = 0, thin = 1)
}
\arguments{
\item{object}{angmcmc object}

\item{burnin.prop}{proportion of iterations to used for burnin. Must be a be a number in [0, 1].
Default is 0.5.}

\item{thin}{thining size to be used. Must be a positive integer. If \code{thin = } n, then every nth iteration is reatained
in the final MCMC sample.}
}
\description{
Add (extra) burnin and thin to angmcmc object after original run
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
lpdtrace(fit.vmsin.20)
# Now add extra burn-in
fit.vmsin.20.burn <- add_burnin_thin(fit.vmsin.20, 0.3)
lpdtrace(fit.vmsin.20.burn)
}
