% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_model_select.R
\name{bestmodel}
\alias{bestmodel}
\title{Extracting angmcmc object corresponding to the best fitted model in stepwise fits}
\usage{
bestmodel(step_object)
}
\arguments{
\item{step_object}{stepwise fitted object obtained from \link{fit_incremental_angmix}.}
}
\value{
Returns an angmcmc object corresponding to the the best fitted model in step_object.
}
\description{
Extracting angmcmc object corresponding to the best fitted model in stepwise fits
}
\examples{
# illustration only - more iterations needed for convergence
set.seed(1)
fit.vmsin.step.15 <- fit_incremental_angmix("vmsin", tim8, start_ncomp = 1,
                                            max_ncomp = 3, n.iter = 15,
                                            n.chains = 1)
fit.vmsin.best.15 <- bestmodel(fit.vmsin.step.15)
fit.vmsin.best.15

}
