% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage_properties.R
\name{get_storage_properties}
\alias{get_storage_properties}
\alias{get_storage_properties.storage_endpoint}
\alias{get_storage_properties.blob_container}
\alias{get_storage_properties.file_share}
\alias{get_blob_properties}
\alias{get_azure_file_properties}
\alias{get_azure_dir_properties}
\title{Get storage properties for an endpoint or container}
\usage{
get_storage_properties(object)

\method{get_storage_properties}{storage_endpoint}(object)

\method{get_storage_properties}{blob_container}(object)

\method{get_storage_properties}{file_share}(object)

get_blob_properties(container, blob)

get_azure_file_properties(share, file)

get_azure_dir_properties(share, dir)
}
\arguments{
\item{object}{An storage object.}

\item{container, share}{A blob container or file share.}

\item{blob, file, dir}{The name of an individual blob, file or directory.}
}
\value{
A list describing the object properties.
}
\description{
Get storage properties for an endpoint or container
}
\details{
The \code{get_storage_properties} generic returns a list of properties for the given storage object. There are methods defined for objects of class \code{storage_endpoint}, \code{blob_container} and \code{file_share}. Similar functions are defined for individual blobs, files and directories.
}
\seealso{
\link{storage_endpoint}, \link{blob_container}, \link{file_share},
[Blob service properties reference[(https://docs.microsoft.com/en-us/rest/api/storageservices/get-blob-service-properties).
\href{https://docs.microsoft.com/en-us/rest/api/storageservices/get-file-service-properties}{File service properties reference},
\href{https://docs.microsoft.com/en-us/rest/api/storageservices/get-container-properties}{Blob container properties reference},
\href{https://docs.microsoft.com/en-us/rest/api/storageservices/get-share-properties}{File share properties reference}
}
