% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_resgroup.R
\docType{class}
\name{az_resource_group}
\alias{az_resource_group}
\title{Azure resource group class}
\format{
An R6 object of class \code{az_resource_group}.
}
\description{
Class representing an Azure resource group.
}
\section{Methods}{

\itemize{
\item \code{new(token, subscription, id, ...)}: Initialize a resource group object. See 'Initialization' for more details.
\item \code{delete(confirm=TRUE)}: Delete this resource group, after a confirmation check. This is asynchronous: while the method returns immediately, the delete operation continues on the host in the background. For resource groups containing a large number of deployed resources, this may take some time to complete.
\item \code{sync_fields()}: Synchronise the R object with the resource group it represents in Azure.
\item \code{list_templates()}: List deployed templates in this resource group.
\item \code{get_template(name)}: Return an object representing an existing template.
\item \code{deploy_template(...)}: Deploy a new template. See 'Templates' for more details.
\item \code{delete_template(name, confirm=TRUE, free_resources=FALSE)}: Delete a deployed template, and optionally free any resources that were created.
\item \code{get_resource(...)}: Return an object representing an existing resource. See 'Resources' for more details.
\item \code{create_resource(...)}: Create a new resource.
\item \code{delete_resource(..., confirm=TRUE, wait=FALSE)}: Delete an existing resource. Optionally wait for the delete to finish.
\item \code{resource_exists(...)}: Check if a resource exists.
\item \code{list_resources()}: Return a list of resource group objects for this subscription.
\item \code{do_operation(...)}: Carry out an operation. See 'Operations' for more details.
\item \code{set_tags(..., keep_existing=TRUE)}: Set the tags on this resource group. The tags can be either names or name-value pairs. To delete a tag, set it to \code{NULL}.
\item \code{get_tags()}: Get the tags on this resource.
\item \code{create_lock(name, level)}: Create a management lock on this resource group (which will propagate to all resources within it).
\item \code{get_lock(name)}: Returns a management lock object.
\item \code{delete_lock(name)}: Deletes a management lock object.
\item \code{list_locks()}: List all locks that apply to this resource group. Note this includes locks created at the subscription level, and for any resources within the resource group.
\item \code{add_role_assignment(name, ...)}: Adds a new role assignment. See 'Role-based access control' below.
\item \code{get_role_assignment(id)}: Retrieves an existing role assignment.
\item \code{remove_role_assignment(id)}: Removes an existing role assignment.
\item \code{list_role_assignments()}: Lists role assignments.
\item \code{get_role_definition(id)}: Retrieves an existing role definition.
\item \code{list_role_definitions()} Lists role definitions.
}
}

\section{Initialization}{

Initializing a new object of this class can either retrieve an existing resource group, or create a new resource group on the host. Generally, the easiest way to create a resource group object is via the \code{get_resource_group}, \code{create_resource_group} or \code{list_resource_groups} methods of the \link{az_subscription} class, which handle this automatically.

To create a resource group object in isolation, supply (at least) an Oauth 2.0 token of class \link{AzureToken}, the subscription ID, and the resource group name. If this object refers to a \emph{new} resource group, supply the location as well (use the \code{list_locations} method of the \verb{az_subscription class} for possible locations). You can also pass any optional parameters for the resource group as named arguments to \code{new()}.
}

\section{Templates}{

To deploy a new template, pass the following arguments to \code{deploy_template()}:
\itemize{
\item \code{name}: The name of the deployment.
\item \code{template}: The template to deploy. This can be provided in a number of ways:
\enumerate{
\item A nested list of name-value pairs representing the parsed JSON
\item The name of a template file
\item A vector of strings containing unparsed JSON
\item A URL from which the template can be downloaded
}
\item \code{parameters}: The parameters for the template. This can be provided using any of the same methods as the \code{template} argument.
\item \code{wait}: Optionally, whether or not to wait until the deployment is complete before returning. Defaults to \code{FALSE}.
}

Retrieving or deleting a deployed template requires only the name of the deployment.
}

\section{Resources}{

There are a number of arguments to \code{get_resource()}, \code{create_resource()} and \code{delete_resource()} that serve to identify the specific resource in question:
\itemize{
\item \code{id}: The full ID of the resource, including subscription ID and resource group.
\item \code{provider}: The provider of the resource, eg \code{Microsoft.Compute}.
\item \code{path}: The full path to the resource, eg \code{virtualMachines}.
\item \code{type}: The combination of provider and path, eg \code{Microsoft.Compute/virtualMachines}.
\item \code{name}: The name of the resource instance, eg \code{myWindowsVM}.
}

Providing the \code{id} argument will fill in the values for all the other arguments. Similarly, providing the \code{type} argument will fill in the values for \code{provider} and \code{path}. Unless you provide \code{id}, you must also provide \code{name}.

To create/deploy a new resource, specify any extra parameters that the provider needs as named arguments to \code{create_resource()}. Like \code{deploy_template()}, \code{create_resource()} also takes an optional \code{wait} argument that specifies whether to wait until resource creation is complete before returning.
}

\section{Operations}{

The \code{do_operation()} method allows you to carry out arbitrary operations on the resource group. It takes the following arguments:
\itemize{
\item \code{op}: The operation in question, which will be appended to the URL path of the request.
\item \code{options}: A named list giving the URL query parameters.
\item \code{...}: Other named arguments passed to \link{call_azure_rm}, and then to the appropriate call in httr. In particular, use \code{body} to supply the body of a PUT, POST or PATCH request, and \code{api_version} to set the API version.
\item \code{http_verb}: The HTTP verb as a string, one of \code{GET}, \code{PUT}, \code{POST}, \code{DELETE}, \code{HEAD} or \code{PATCH}.
}

Consult the Azure documentation for what operations are supported.
}

\section{Role-based access control}{

AzureRMR implements a subset of the full RBAC functionality within Azure Active Directory. You can retrieve role definitions and add and remove role assignments, at the subscription, resource group and resource levels. See \link{rbac} for more information.
}

\examples{
\dontrun{

# recommended way to retrieve a resource group object
rg <- get_azure_login("myaadtenant")$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# list resources & templates in this resource group
rg$list_resources()
rg$list_templates()

# get a resource (virtual machine)
rg$get_resource(type="Microsoft.Compute/virtualMachines", name="myvm")

# create a resource (storage account)
rg$create_resource(type="Microsoft.Storage/storageAccounts", name="mystorage",
    kind="StorageV2",
    sku=list(name="Standard_LRS"))

# delete a resource
rg$delete_resource(type="Microsoft.Storage/storageAccounts", name="mystorage")

# deploy a template
rg$deploy_template("tplname",
    template="template.json",
    parameters="parameters.json")

# deploy a template with parameters inline
rg$deploy_template("mydeployment",
    template="template.json",
    parameters=list(parm1="foo", parm2="bar"))

# delete a template and free resources
rg$delete_template("tplname", free_resources=TRUE)

# delete the resource group itself
rg$delete()

}
}
\seealso{
\link{az_subscription}, \link{az_template}, \link{az_resource},
\href{https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-group-overview#resource-groups}{Azure resource group overview},
\href{https://docs.microsoft.com/en-us/rest/api/resources/resources}{Resources API reference},
\href{https://docs.microsoft.com/en-us/rest/api/resources/deployments}{Template API reference}

For role-based access control methods, see \link{rbac}

For management locks, see \link{lock}
}
