% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_kusto.R
\docType{class}
\name{az_kusto}
\alias{az_kusto}
\alias{create_database}
\alias{get_database}
\alias{delete_database}
\alias{list_databases}
\title{Kusto/Azure Data Explorer cluster resource class}
\description{
Class representing a Kusto cluster, exposing methods for working with it.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{new(...)}: Initialize a new storage object. See 'Initialization'.
\item \code{start()}: Start the cluster.
\item \code{stop()}: Stop the cluster.
\item \code{create_database(...)}: Create a new Kusto database. See \code{Databases} below.
\item \verb{get_database(database))}: Get an existing database.
\item \code{delete_database(database, confirm=TRUE)}: Delete a database, by default asking for confirmation first.
\item \code{list_databases()}: List all databases in this cluster.
\item \code{get_default_tenant()}: Retrieve the default tenant to authenticate with this cluster.
\item \code{get_query_token(tenant, ...)}: Obtain an authentication token from Azure Active Directory for this cluster's query enpdoint. Accepts further arguments that will be passed to \link{get_kusto_token}.
\item \code{get_ingestion_token(tenant, ...)}: Obtain an authentication token for this cluster's ingestion endpoint. Accepts further arguments that will be passed to \link{get_kusto_token}.
}
}

\section{Initialization}{

Initializing a new object of this class can either retrieve an existing Kusto cluster, or create a new cluster on the host. Generally, the best way to initialize an object is via the \code{get_kusto_cluster} and \code{create_kusto_cluster} methods of the \link{az_resource_group} class, which handle the details automatically.
}

\section{Databases}{

A Kusto cluster can have several databases, which are represented in AzureKusto via \link{az_kusto_database} R6 objects. The \code{az_kusto} class provides the \code{create_database}, \code{get_database}, \code{delete_database} and \code{list_databases} methods for creating, deleting and retrieving databases. It's recommended to use these methods rather than calling \code{az_kusto_database$new()} directly.

\code{create_database} takes the following arguments. It returns an object of class \link{az_kusto_database}
\itemize{
\item \code{database}: The name of the database to create.
\item \code{retention_period}: The retention period of the database, after which data will be soft-deleted.
\item \code{cache_period}: The cache period of the database, the length of time for which queries will be cached.
}

\code{get_database} takes a single argument \code{database}, the name of the database to retrieve, and returns an object of class \code{az_kusto_database}. \code{delete_database} takes the name of the database to delete and returns NULL on a successful deletion. \code{list_databases} takes no arguments and returns a list of \code{az_kusto_database} objects, one for each database in the cluster.
}

\examples{
\dontrun{

# recommended way of retrieving a resource: via a resource group object
kus <- resgroup$get_kusto_cluster("mykusto")

# list databases
kust$list_databases()

# create a new database with a retention period of 6 months
kust$create_database("newdb", retention_period=180)

# get the default authentication tenant
kus$get_default_tenant()

# generate an authentication token
kust$get_aad_token()

}
}
\seealso{
\link{az_kusto_database}, \link{kusto_database_endpoint},
\link{create_kusto_cluster}, \link{get_kusto_cluster}, \link{delete_kusto_cluster},
\link{get_kusto_token}

\href{https://docs.microsoft.com/en-us/azure/data-explorer/}{Kusto/Azure Data Explorer documentation},
}
\section{Super class}{
\code{\link[AzureRMR:az_resource]{AzureRMR::az_resource}} -> \code{az_kusto}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-start}{\code{az_kusto$start()}}
\item \href{#method-stop}{\code{az_kusto$stop()}}
\item \href{#method-create_database}{\code{az_kusto$create_database()}}
\item \href{#method-get_database}{\code{az_kusto$get_database()}}
\item \href{#method-delete_database}{\code{az_kusto$delete_database()}}
\item \href{#method-list_databases}{\code{az_kusto$list_databases()}}
\item \href{#method-get_default_tenant}{\code{az_kusto$get_default_tenant()}}
\item \href{#method-get_query_token}{\code{az_kusto$get_query_token()}}
\item \href{#method-get_ingestion_token}{\code{az_kusto$get_ingestion_token()}}
\item \href{#method-clone}{\code{az_kusto$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="add_role_assignment">}\href{../../AzureRMR/html/az_resource.html#method-add_role_assignment}{\code{AzureRMR::az_resource$add_role_assignment()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="create_lock">}\href{../../AzureRMR/html/az_resource.html#method-create_lock}{\code{AzureRMR::az_resource$create_lock()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="delete">}\href{../../AzureRMR/html/az_resource.html#method-delete}{\code{AzureRMR::az_resource$delete()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="delete_lock">}\href{../../AzureRMR/html/az_resource.html#method-delete_lock}{\code{AzureRMR::az_resource$delete_lock()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="do_operation">}\href{../../AzureRMR/html/az_resource.html#method-do_operation}{\code{AzureRMR::az_resource$do_operation()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="get_api_version">}\href{../../AzureRMR/html/az_resource.html#method-get_api_version}{\code{AzureRMR::az_resource$get_api_version()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="get_lock">}\href{../../AzureRMR/html/az_resource.html#method-get_lock}{\code{AzureRMR::az_resource$get_lock()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="get_role_assignment">}\href{../../AzureRMR/html/az_resource.html#method-get_role_assignment}{\code{AzureRMR::az_resource$get_role_assignment()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="get_role_definition">}\href{../../AzureRMR/html/az_resource.html#method-get_role_definition}{\code{AzureRMR::az_resource$get_role_definition()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="get_tags">}\href{../../AzureRMR/html/az_resource.html#method-get_tags}{\code{AzureRMR::az_resource$get_tags()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="initialize">}\href{../../AzureRMR/html/az_resource.html#method-initialize}{\code{AzureRMR::az_resource$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="list_locks">}\href{../../AzureRMR/html/az_resource.html#method-list_locks}{\code{AzureRMR::az_resource$list_locks()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="list_role_assignments">}\href{../../AzureRMR/html/az_resource.html#method-list_role_assignments}{\code{AzureRMR::az_resource$list_role_assignments()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="list_role_definitions">}\href{../../AzureRMR/html/az_resource.html#method-list_role_definitions}{\code{AzureRMR::az_resource$list_role_definitions()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="print">}\href{../../AzureRMR/html/az_resource.html#method-print}{\code{AzureRMR::az_resource$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="remove_role_assignment">}\href{../../AzureRMR/html/az_resource.html#method-remove_role_assignment}{\code{AzureRMR::az_resource$remove_role_assignment()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="set_api_version">}\href{../../AzureRMR/html/az_resource.html#method-set_api_version}{\code{AzureRMR::az_resource$set_api_version()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="set_tags">}\href{../../AzureRMR/html/az_resource.html#method-set_tags}{\code{AzureRMR::az_resource$set_tags()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="sync_fields">}\href{../../AzureRMR/html/az_resource.html#method-sync_fields}{\code{AzureRMR::az_resource$sync_fields()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="AzureRMR" data-topic="az_resource" data-id="update">}\href{../../AzureRMR/html/az_resource.html#method-update}{\code{AzureRMR::az_resource$update()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-start"></a>}}
\if{latex}{\out{\hypertarget{method-start}{}}}
\subsection{Method \code{start()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{az_kusto$start()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stop"></a>}}
\if{latex}{\out{\hypertarget{method-stop}{}}}
\subsection{Method \code{stop()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{az_kusto$stop()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-create_database"></a>}}
\if{latex}{\out{\hypertarget{method-create_database}{}}}
\subsection{Method \code{create_database()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{az_kusto$create_database(database, retention_period = 3650, cache_period = 31)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_database"></a>}}
\if{latex}{\out{\hypertarget{method-get_database}{}}}
\subsection{Method \code{get_database()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{az_kusto$get_database(database)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete_database"></a>}}
\if{latex}{\out{\hypertarget{method-delete_database}{}}}
\subsection{Method \code{delete_database()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{az_kusto$delete_database(database, confirm = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-list_databases"></a>}}
\if{latex}{\out{\hypertarget{method-list_databases}{}}}
\subsection{Method \code{list_databases()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{az_kusto$list_databases()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_default_tenant"></a>}}
\if{latex}{\out{\hypertarget{method-get_default_tenant}{}}}
\subsection{Method \code{get_default_tenant()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{az_kusto$get_default_tenant()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_query_token"></a>}}
\if{latex}{\out{\hypertarget{method-get_query_token}{}}}
\subsection{Method \code{get_query_token()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{az_kusto$get_query_token(tenant = self$get_default_tenant(), ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_ingestion_token"></a>}}
\if{latex}{\out{\hypertarget{method-get_ingestion_token}{}}}
\subsection{Method \code{get_ingestion_token()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{az_kusto$get_ingestion_token(tenant = self$get_default_tenant(), ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{az_kusto$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
