% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TW_main.R
\name{tw}
\alias{tw}
\title{Tracy-Widom test}
\usage{
tw(eigenvalues, eigenL, criticalpoint = 2.0234)
}
\arguments{
\item{eigenvalues}{a numeric vector whose elements are the
eigenvalues of a matrix. The values should be sorted in the
descending order.}

\item{eigenL}{the number of eigenvalues.}

\item{criticalpoint}{a numeric value corresponding to the
significance level. If the significance level is 0.05, 0.01,
0.005, or 0.001, the \code{criticalpoint} should be set to be \code{0.9793},
\code{2.0234}, \code{2.4224}, or \code{3.2724}, accordingly. The default is \code{2.0234}.}
}
\value{
A list with class "\code{htest}" containing the following components:
\tabular{llll}{
\code{statistic} \tab \tab \tab \cr
\tab \tab \tab a vector of the Tracy-Widom statistics.\cr
\code{alternative} \tab \tab \tab \cr
\tab \tab \tab a character string describing the alternative hypothesis.\cr
\code{method} \tab \tab \tab \cr
\tab \tab \tab a character string indicating the type of test performed.\cr
\code{data.name} \tab \tab \tab \cr
\tab \tab \tab a character string giving the name of the data. \cr
\code{SigntEigenL} \tab \tab \tab \cr
\tab \tab \tab the number of significant eigenvalues.
}
}
\description{
Find the significant eigenvalues of a matrix.
}
\examples{
tw(eigenvalues = c(5, 3, 1, 0), eigenL = 4, criticalpoint = 2.0234)
}
\references{
Lin Wang, Wei Zhang, and Qizhai Li. AssocTests: An R Package 
for Genetic Association Studies. \emph{Journal of Statistical Software}. 
2020; 94(5): 1-26.

N Patterson, AL Price, and D Reich. Population
Structure and Eigenanalysis. \emph{PloS Genetics}. 2006; 2(12):
2074-2093.

CA Tracy and H Widom. Level-Spacing Distributions and
the Airy Kernel. \emph{Communications in Mathematical
Physics}. 1994; 159(1): 151-174.

A Bejan. Tracy-Widom and Painleve II: Computational
Aspects and Realisation in S-Plus. In \emph{First Workshop of the ERCIM
Working Group on Computing and Statistics}. 2008, Neuchatel, Switzerland.

A Bejan. Largest eigenvalues and sample covariance matrices. 
\emph{MSc Dissertation, the university of Warwick}. 2005. (This function
was written by A Bejan and publicly downloadable.)
}
\author{
Lin Wang, Wei Zhang, and Qizhai Li.
}
