% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Operations.R
\name{appendToTable}
\alias{appendToTable}
\title{Append to an Andromeda table}
\usage{
appendToTable(tbl, data)
}
\arguments{
\item{tbl}{An \code{\link{Andromeda}} table. This must be a base table (i.e. it cannot be a query result).}

\item{data}{The data to append. This can be either a data.frame or another Andromeda table.}
}
\value{
Returns no value. Executed for the side-effect of appending the data to the table.
}
\description{
Append a data frame, Andromeda table, or result of a query on an \code{\link{Andromeda}} table to an existing
\code{\link{Andromeda}} table.

If data from another \code{\link{Andromeda}} is appended, a batch-wise copy process is used, which will be slower
than when appending data from within the same \code{\link{Andromeda}} object.

\strong{Important}: columns are appended based on column name, not on column order. The column names should
therefore be identical (but not necessarily in the same order).
}
\examples{
andr <- andromeda(cars = cars)
nrow(andr$cars)
# [1] 50

appendToTable(andr$cars, cars)
nrow(andr$cars)
# [1] 100

appendToTable(andr$cars, andr$cars \%>\% filter(speed > 10))
nrow(andr$cars)
# [1] 182

close(andr)

}
