% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterObject.R
\name{geomMean}
\alias{geomMean}
\title{Take the geometric mean of a vector}
\usage{
geomMean(x, rm.invalid = TRUE, default = 1e-05)
}
\arguments{
\item{x}{A vector of numerical .}

\item{rm.invalid}{Boolean value for handling 0, negative, or NA values in the vector. Default is TRUE and will not
include these values in the calculation. If FALSE, these values will be replaced by the value give to \code{default} and will
be included in the calculation.}

\item{default}{Numerical value that serves as the value to replace 0, negative, or NA values in the calculation when rm.invalid is FALSE.
Default is 1e-5.}
}
\value{
Returns the geometric mean of a vector.
}
\description{
\code{geomMean} will calculate the geometric mean of a list of numerical values.
}
\details{
This function is a special version of the geometric mean specifically for AnaCoda.
Most models in Anacoda assume a log normal distribution for phi values, thus all values in \code{x} are expectd to be positive.
geomMean returns the geometric mean of a vector and can handle 0, negative, or NA values.
}
\examples{
x <- c(1, 2, 3, 4)
geomMean(x)

y<- c(1, NA, 3, 4, 0, -1)
# Only take the mean of non-Na values greater than 0
geomMean(y)

# Replace values <= 0 or NAs with a default value 0.001 and then take the mean
geomMean(y, rm.invalid = FALSE, default = 0.001)

}
