% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterObject.R
\name{getMixtureAssignmentEstimate}
\alias{getMixtureAssignmentEstimate}
\title{Returns mixture assignment estimates for each gene}
\usage{
getMixtureAssignmentEstimate(parameter, gene.index, samples)
}
\arguments{
\item{parameter}{on object created by \code{initializeParameterObject}}

\item{gene.index}{a integer or vector of integers representing the gene(s) of interesst.}

\item{samples}{number of samples for the posterior estimate}
}
\value{
returns a vector with the mixture assignment of each gene corresbonding to \code{gene.index} in the same order as the genome.
}
\description{
Posterior estimates for the mixture assignment of specified genes
}
\details{
The returned vector is unnamed as gene ids are only stored in the \code{genome} object, 
but the \code{gene.index} vector can be used to match the assignment to the genome.
}
\examples{
 
genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")

genome <- initializeGenomeObject(file = genome_file)
sphi_init <- c(1,1)
numMixtures <- 2
geneAssignment <- sample(1:2, length(genome), replace = TRUE) # random assignment to mixtures
parameter <- initializeParameterObject(genome = genome, sphi = sphi_init, 
                                       num.mixtures = numMixtures, 
                                       gene.assignment = geneAssignment, 
                                       mixture.definition = "allUnique")
model <- initializeModelObject(parameter = parameter, model = "ROC")
samples <- 2500
thinning <- 50
adaptiveWidth <- 25
mcmc <- initializeMCMCObject(samples = samples, thinning = thinning, adaptive.width=adaptiveWidth, 
                             est.expression=TRUE, est.csp=TRUE, est.hyper=TRUE, est.mix = TRUE) 
divergence.iteration <- 10
\dontrun{
runMCMC(mcmc = mcmc, genome = genome, model = model, 
        ncores = 4, divergence.iteration = divergence.iteration)

# get the mixture assignment for all genes
mixAssign <- getMixtureAssignmentEstimate(parameter = parameter, 
                                          gene.index = 1:length(genome), samples = 1000)

# get the mixture assignment for a subsample
mixAssign <- getMixtureAssignmentEstimate(parameter = parameter, 
                                          gene.index = 5:100, samples = 1000)
# or
mixAssign <- getMixtureAssignmentEstimate(parameter = parameter, 
                                          gene.index = c(10, 30:50, 3, 90), samples = 1000)
}

}
