% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iff.0.r
\docType{methods}
\name{getIFFChunk}
\alias{getIFFChunk}
\alias{getIFFChunk,IFFChunk,character,integer-method}
\alias{getIFFChunk,IFFChunk,character,missing-method}
\alias{getIFFChunk<-}
\alias{getIFFChunk<-,IFFChunk,character,missing,IFFChunk-method}
\alias{getIFFChunk<-,IFFChunk,character,integer,IFFChunk-method}
\title{Get a specific IFFChunk nested inside other IFFChunks}
\usage{
\S4method{getIFFChunk}{IFFChunk,character,integer}(x, chunk.path, chunk.number)

\S4method{getIFFChunk}{IFFChunk,character,missing}(x, chunk.path, chunk.number)

\S4method{getIFFChunk}{IFFChunk,character,missing,IFFChunk}(x, chunk.path, chunk.number = NULL) <- value

\S4method{getIFFChunk}{IFFChunk,character,integer,IFFChunk}(x, chunk.path, chunk.number = NULL) <- value
}
\arguments{
\item{x}{An \code{\link[=IFFChunk]{IFFChunk()}} object from which the nested
\code{\link[=IFFChunk]{IFFChunk()}} should be extracted an returned.}

\item{chunk.path}{A \code{vector} of 4 \code{character} long strings
of IFF chunk labels, specifying the path of the target IFF chunk.
For example: \code{c("ILBM", "BODY")} means, get the "BODY" chunk
from inside the "ILBM" chunk.}

\item{chunk.number}{A \code{vector} of the same length as \code{chunk.path},
with \code{integer} index numbers. Sometimes a chunk can contain a list of
chunks with the same label. With this argument you can specify which element
should be returned. By default (when missing), the first element is always
returned.}

\item{value}{An \code{\link[=IFFChunk]{IFFChunk()}} with which the target chunk should be
replaced. Make sure that \code{value} is of the same \code{chunk.type} as the last
chunk specified in the \code{chunk.path}.}
}
\value{
Returns an \code{\link[=IFFChunk]{IFFChunk()}} object nested inside \code{x} at the
specified path. Or in case of the replace method the original chunk \code{x} is
returned with the target chunk replaced by \code{value}.
}
\description{
\code{\link[=IFFChunk]{IFFChunk()}}s can be nested in a tree-like structure. Use this method
to get a specific chunk with a specific label.
}
\details{
\code{IFFChunk} objects have 4 \code{character} identifiers, indicating what type
of chunk you are dealing with. These chunks can be nested inside of each other.
Use this method to extract specific chunks by referring to there respective
identifiers. The identifiers are shown when calling \code{print} on an
\code{\link[=IFFChunk]{IFFChunk()}}. If a specified path doesn't exist, this method throws a
`subscript out of range' error.
}
\examples{
\dontrun{
## load an IFF file
example.iff <- read.iff(system.file("ilbm8lores.iff", package = "AmigaFFH"))

## Get the BMHD (bitmap header) from the ILBM (interleaved bitmap) chunk:
bmhd <- getIFFChunk(example.iff, c("ILBM", "BMHD"))

## This is essentially doing the same thing, but we now explicitly
## tell the method to get the first element for each specified label:
bmhd <- getIFFChunk(example.iff, c("ILBM", "BMHD"), c(1L, 1L))

## Let's modify the bitmap header and replace it in the parent IFF chunk.
bmhd.itpt <- interpretIFFChunk(bmhd)

## Let's disable the masking, the bitmap will no longer be transparent:
bmhd.itpt$Masking <- "mskNone"
bmhd <- IFFChunk(bmhd.itpt)

## Now replace the header from the original iff with the modified header:
getIFFChunk(example.iff, c("ILBM", "BMHD")) <- bmhd
}
}
\seealso{
Other iff.operations: 
\code{\link{IFFChunk-class}},
\code{\link{WaveToIFF}()},
\code{\link{as.raster.AmigaBasicShape}()},
\code{\link{interpretIFFChunk}()},
\code{\link{rasterToIFF}()},
\code{\link{rawToIFFChunk}()},
\code{\link{read.iff}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{iff.operations}
