% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossing.R
\name{randCross2}
\alias{randCross2}
\title{Make random crosses}
\usage{
randCross2(
  females,
  males,
  nCrosses,
  nProgeny = 1,
  balance = TRUE,
  femaleParents = NULL,
  maleParents = NULL,
  ignoreSexes = FALSE,
  simParam = NULL
)
}
\arguments{
\item{females}{an object of \code{\link{Pop-class}} for female parents.}

\item{males}{an object of \code{\link{Pop-class}} for male parents.}

\item{nCrosses}{total number of crosses to make}

\item{nProgeny}{number of progeny per cross}

\item{balance}{this option will balance the number 
of progeny per parent}

\item{femaleParents}{an optional vector of indices for allowable 
female parents}

\item{maleParents}{an optional vector of indices for allowable 
male parents}

\item{ignoreSexes}{should sex be ignored}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
A wrapper for \code{\link{makeCross2}} that randomly 
selects parental combinations for all possible combinantions between 
two populations.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

#Create population
pop = newPop(founderPop, simParam=SP)

#Make 10 crosses
pop2 = randCross2(pop, pop, 10, simParam=SP)

}
