% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{pullSnpGeno}
\alias{pullSnpGeno}
\title{Pull SNP genotype}
\usage{
pullSnpGeno(pop, snpChip = 1, chr = NULL, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{snpChip}{an integer. Indicates which SNP
chip's genotypes to retrieve.}

\item{chr}{a vector of chromosomes to retrieve. If NULL,
all chromosome are retrieved.}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns a matrix of SNP genotypes.
}
\description{
Retrieves SNP genotype data
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$addSnpChip(5)

#Create population
pop = newPop(founderPop, simParam=SP)
pullSnpGeno(pop, simParam=SP)

}
