% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.csv.R
\name{write.csv}
\alias{write.csv}
\alias{write.csv.default}
\alias{write.csv.AlphaPart}
\alias{write.csv.summaryAlphaPart}
\title{write.csv.R}
\usage{
write.csv(...)

\method{write.csv}{default}(...)

\method{write.csv}{AlphaPart}(x, file, traitsAsDir = FALSE,
  csv2 = TRUE, row.names = FALSE, ...)

\method{write.csv}{summaryAlphaPart}(x, file, traitsAsDir = FALSE,
  csv2 = TRUE, row.names = FALSE, ...)
}
\arguments{
\item{...}{Other options passed to \code{\link[utils]{write.csv2}} or \code{\link[utils]{write.csv}}.}

\item{x}{AlphaPart, object returned from \code{\link[AlphaPart]{AlphaPart}} function or
summaryAlphaPart, object returned from \code{\link[AlphaPart]{summary.AlphaPart}} function.}

\item{file}{Character, file name with or without .csv extension, e.g., both "file" and "file.csv" are valid.}

\item{traitsAsDir}{Logical, should results be saved within trait folders;
the construction is \code{file.path(dirname(file), trait, basename(file))};
folders are created if they do not exist.}

\item{csv2}{Logical, export using \code{\link[utils]{write.csv2}} or \code{\link[utils]{write.csv}}.}

\item{row.names}{Logical, export row names as well?}
}
\value{
\item{write.csv}{See \code{\link[utils]{write.csv}} for details.}
         \item{write.csv.AlphaPart}{For each trait (list component in \code{x}) a file is saved on disk with name
"file_trait.csv", where the file will hold original data and additive genetic value partitions.
With \code{traitsAsDir=TRUE} files are saved as "trait/file_trait.csv".
File names are printed on screen during the process of export and at the end invisibly returned.}
         |item{write.csv.summaryAlphaPart}{For each trait (list component in \code{x}) two files are saved on disk with names
"file_trait_abs.csv" and "file_trait_rel.csv", where the first file will hold absolute values
and the second file will hold relative values of additive genetic value partitions.
With \code{traitsAsDir=TRUE} files are saved as "trait/file_trait_*.csv". File names
are printed on screen during the process of export and at the end invisibly returned.}
}
\description{
Save summaries of partitioned additive genetic values to CSV files on disk for further
analyses of processing with other software or just for saving (backing up)
results.
}
\details{
Function \code{\link[utils]{write.csv}} from the \pkg{utils} package works
when exported object is a \code{\link[base]{data.frame}} or a
\code{\link[base]{matrix}}. This is an attempt to make this function generic
so that one can define \code{write.csv} methods for other objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default \code{write.csv} method.

\item \code{AlphaPart}: Save partitioned additive genetic values to CSV files on disk on disk for further
analyses or processing with other software or just for saving (backing up)
results.

\item \code{summaryAlphaPart}: Save summaries of partitioned additive genetic values to CSV files on disk for further
analyses of processing with other software or just for saving (backing up)
results.
}}

\examples{
## Load an example data
data("AlphaPart.ped")

## Partition additive genetic values
res <- AlphaPart(x=AlphaPart.ped, colPath="loc", colAGV=c("agv1", "agv2"))

## Write summary on the disk and collect saved file names
fileName <- file.path(tempdir(), "AlphaPart")
ret <- write.csv(x=res, file=fileName)
print(ret)
file.show(ret[1])

## Clean up
files <- dir(path=tempdir(), pattern="AlphaPart*")
unlink(x=files)

}
\seealso{
\code{\link[utils]{write.csv}} help page on the default \code{write.csv} and \code{write.csv2}
methods in the \pkg{utils} package;
\code{\link[AlphaPart]{summary.AlphaPart}} and \code{\link[AlphaPart]{AlphaPart}}
help pages on the objects of \code{summaryAlphaPart} and \code{AlphaPart} classes.
}
