% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_dailyThreshold.R
\name{monitor_dailyThreshold}
\alias{monitor_dailyThreshold}
\title{Daily counts of values at or above a threshold}
\usage{
monitor_dailyThreshold(
  monitor = NULL,
  threshold = NULL,
  na.rm = TRUE,
  minHours = 18,
  dayBoundary = c("clock", "LST")
)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{threshold}{AQI level name (e.g. \code{"unhealthy"}) or numerical
threshold at and above which a measurement is counted.}

\item{na.rm}{Logical value indicating whether NA values should be ignored.}

\item{minHours}{Minimum number of valid hourly records per day required to
calculate statistics. Days with fewer valid records will be assigned \code{NA}.}

\item{dayBoundary}{Treatment of daylight savings time:  "clock" uses daylight
savings time as defined in the local timezone, "LST" uses "local standard time"
all year round.}
}
\value{
A \emph{mts_monitor} object containing daily counts of hours at or above
a threshold value. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Calculates the number of hours per day each time series in \code{monitor} was
at or above a given threshold.

Because the returned \emph{mts_monitor} object is defined on a daily axis in a
specific time zone, it is important that the incoming \code{monitor} contain
only timeseries within a single time zone.
}
\note{
When \code{dayBoundary = "clock"}, the returned \code{monitor$data$datetime}
time axis will be defined in the local timezone (not "UTC") with days defined
by midnight as it appears on a clock in that timezone. The transition from
DST to standard time will result in a 23 hour day and standard to DST in a
25 hour day.

When \code{dayBoundary = "LST"}, the returned \code{monitor$data$datetime}
time axis will be defined in "UTC" with times as they \emph{appear} in standard
time in the local timezone. These days will be one hour off from clock
time during DST but every day will consist of 24 hours.
}
\examples{
library(AirMonitor)

Carmel_Valley \%>\%
  monitor_dailyThreshold("Moderate") \%>\%
  monitor_getData()

Carmel_Valley \%>\%
  monitor_dailyThreshold("Unhealthy") \%>\%
  monitor_getData()

}
