% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_aqi.R
\name{monitor_aqi}
\alias{monitor_aqi}
\title{Calculate hourly NowCast-based AQI values}
\usage{
monitor_aqi(
  monitor,
  version = c("pm", "pmAsian", "ozone"),
  includeShortTerm = FALSE
)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{version}{Name of the type of nowcast algorithm to be used.}

\item{includeShortTerm}{Logical specifying whether to alcluate preliminary
NowCast values starting with the 2nd hour.}
}
\value{
A modified \code{mts_monitor} object containing AQI values. (A list
with \code{meta} and \code{data} dataframes.)
}
\description{
Nowcast and AQI algorithms are applied to the data in the
monitor object. A modified \code{mts_monitor} object is returned whre values
have been replaced with their Air Quality Index equivalents. See \link{monitor_nowcast}.
}
\references{
\url{https://en.wikipedia.org/wiki/Nowcast_(Air_Quality_Index)}

\url{https://www.airnow.gov/aqi/aqi-basics/}
}
