% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_loadDaily.R
\name{wrcc_loadDaily}
\alias{wrcc_loadDaily}
\title{Load daily WRCC monitoring data}
\usage{
wrcc_loadDaily(
  archiveBaseUrl = paste0("https://airfire-data-exports.s3.us-west-2.amazonaws.com/",
    "monitoring/v2"),
  archiveBaseDir = NULL,
  QC_negativeValues = c("zero", "na", "ignore")
)
}
\arguments{
\item{archiveBaseUrl}{Base URL for monitoring v2 data files.}

\item{archiveBaseDir}{Local base directory for monitoring v2 data files.}

\item{QC_negativeValues}{Type of QC to apply to negative values.}
}
\value{
A \emph{mts_monitor} object with WRCC data. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Loads pre-generated .rda files containing daily
WRCC data.

If \code{archiveDataDir} is defined, data will be loaded from this local
archive. Otherwise, data will be loaded from the monitoring data repository
maintained by the USFS AirFire team.

The files loaded by this function are updated once per day and
contain data for the previous 45 days.

For the most recent data in the last 10 days, use \code{wrcc_loadLatest()}.

For data extended more than 45 days into the past, use \code{wrcc_loadAnnual()}.
}
\examples{
\dontrun{
library(AirMonitor)

# Fail gracefully if any resources are not available
try({

wrcc_loadDaily() \\%>\\%
  monitor_leaflet()

}, silent = FALSE)
}
}
\seealso{
\code{\link{wrcc_loadAnnual}}

\code{\link{wrcc_loadDaily}}
}
