% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LM23i_analysis.R
\name{LM23i}
\alias{LM23i}
\title{Analysis: Cubic inverse without beta1}
\usage{
LM23i(
  trat,
  resp,
  ylab = "Dependent",
  error = "SE",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  r2 = "all",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  round = NA,
  xname.formula = "x",
  yname.formula = "y",
  comment = NA,
  fontfamily = "sans"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{ylab}{Dependent variable name (Accepts the \emph{expression}() function)}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{xlab}{Independent variable name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (default is 21)}

\item{round}{round equation}

\item{xname.formula}{Name of x in the equation}

\item{yname.formula}{Name of y in the equation}

\item{comment}{Add text after equation}

\item{fontfamily}{Font family}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
Degree 3 polynomial inverse model without the beta 1 coefficient.
}
\details{
Inverse degree 3 polynomial model without the beta 1 coefficient  is defined by:
\deqn{y = \beta_0 + \beta_2\cdot x^{1/2} + \beta_3\cdot x^{1/3}}
}
\examples{
library(AgroReg)
data("granada")
attach(granada)
LM23i(time, WL)
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
\keyword{linear}
\keyword{regression}
