% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomial_function.R
\name{polynomial}
\alias{polynomial}
\title{Analysis: Linear regression graph}
\usage{
polynomial(
  trat,
  resp,
  ylab = "Response",
  xlab = "Independent",
  yname.poly = "y",
  xname.poly = "x",
  grau = NA,
  theme = theme_classic(),
  point = "mean_sd",
  color = "gray80",
  posi = "top",
  textsize = 12,
  se = FALSE,
  ylim = NA,
  family = "sans",
  pointsize = 4.5,
  linesize = 0.8,
  width.bar = NA,
  n = NA,
  SSq = NA,
  DFres = NA
)
}
\arguments{
\item{trat}{Numerical vector with treatments (Declare as numeric)}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{ylab}{Dependent variable name (Accepts the \emph{expression}() function)}

\item{xlab}{Independent variable name (Accepts the \emph{expression}() function)}

\item{yname.poly}{Y name in equation}

\item{xname.poly}{X name in equation}

\item{grau}{Degree of the polynomial (1, 2 or 3)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{point}{Defines whether to plot mean ("mean"), all repetitions ("all"),mean with standard deviation ("mean_sd") or mean with standard error (\emph{default} - "mean_se").}

\item{color}{Graph color (\emph{default} is gray80)}

\item{posi}{Legend position}

\item{textsize}{Font size}

\item{se}{Adds confidence interval (\emph{default} is FALSE)}

\item{ylim}{y-axis scale}

\item{family}{Font family}

\item{pointsize}{Point size}

\item{linesize}{line size (Trendline and Error Bar)}

\item{width.bar}{width of the error bars of a regression graph.}

\item{n}{Number of decimal places for regression equations}

\item{SSq}{Sum of squares of the residue}

\item{DFres}{Residue freedom degrees}
}
\value{
Returns linear, quadratic or cubic regression analysis.
}
\description{
Linear regression analysis of an experiment with a quantitative factor or isolated effect of a quantitative factor
}
\examples{
data("phao")
with(phao, polynomial(dose,comp, grau = 2))
}
\seealso{
\link{polynomial2}, \link{polynomial2_color}
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{Experimental}
\keyword{Regression}
