% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualitycontrol.R
\name{qualitycontrol}
\alias{qualitycontrol}
\title{Quality Control of a Pollen Database}
\usage{
qualitycontrol(data, int.window = 2, perc.miss = 20,
  ps.method = "percentage", export.result = TRUE,
  export.format = "pdf", th.day = 100, perc = 95,
  def.season = "natural", reduction = FALSE, red.level = 0.9,
  derivative = 5, man = 11, th.ma = 5, n.clinical = 5,
  window.clinical = 7, window.grains = 5, th.pollen = 10,
  th.sum = 100, type = "none", int.method = "lineal",
  export.width = 10, export.height = 10, ...)
}
\arguments{
\item{data}{A \code{data.frame} object including the general database where quality must be checked. This data.frame must include a first column in \code{Date} format and the rest of columns in \code{numeric} format belonging to each pollen type by column. It is not necessary to insert the missing gaps; the function will automatically detect them.}

\item{int.window}{A  \code{numeric (interger)}value bigger or equal to \code{1}. The argument specifies the number of days of each side of the start, peak or end date of the main pollen season which will be checked during the quality control. If any of these days has been interpolated, the current season will not pass the quality control. The \code{int.window} argument will be \code{2} by default.}

\item{perc.miss}{A \code{numeric (interger)} value between \code{0} and \code{100}. The argument specifies the maximal percentage of interpolated days which is allowed inside the main pollen season to pass the quality control. The \code{perc.miss} argument will be \code{20} by default.}

\item{ps.method}{A \code{character} string specifying the method applied to calculate the pollen season and the main parameters. The implemented methods that can be used are: \code{"percentage"}, \code{"logistic"}, \code{"moving"}, \code{"clinical"} or \code{"grains"}. A more detailed information about the different methods for defining the pollen season may be consulted in \code{\link{calculate_ps}} function. The \code{ps.method} argument will be \code{"percentage"} by default.}

\item{export.result}{A \code{logical} argument. If \code{TRUE}, graphical resume of the quality control and pollen season parameters will be exported in your working directory and a new folder (\emph{"table_AeRobiology"}) will be created with a \code{xlsx} file inside including all parameters calculated from the definition of the pollen season. A more detailed information may be consulted in Details and \code{\link{calculate_ps}} function. The \code{export.result} argument will be \code{TRUE} by default.}

\item{export.format}{A \code{character} string specifying the file extension of the quality control graphical resume when its saved. Only valid if \code{export.result = TRUE}. The implemented options that can be used are: \code{"pdf", "png", "jpeg", "tiff"} or \code{"bmp"}. The argument will be \code{"pdf"} by default.}

\item{th.day}{See \code{\link{calculate_ps}} for more details.}

\item{perc}{See \code{\link{calculate_ps}} for more details.}

\item{def.season}{See \code{\link{calculate_ps}} for more details.}

\item{reduction}{See \code{\link{calculate_ps}} for more details.}

\item{red.level}{See \code{\link{calculate_ps}} for more details.}

\item{derivative}{See \code{\link{calculate_ps}} for more details.}

\item{man}{See \code{\link{calculate_ps}} for more details.}

\item{th.ma}{See \code{\link{calculate_ps}} for more details.}

\item{n.clinical}{See \code{\link{calculate_ps}} for more details.}

\item{window.clinical}{See \code{\link{calculate_ps}} for more details.}

\item{window.grains}{See \code{\link{calculate_ps}} for more details.}

\item{th.pollen}{See \code{\link{calculate_ps}} for more details.}

\item{th.sum}{See \code{\link{calculate_ps}} for more details.}

\item{type}{See \code{\link{calculate_ps}} for more details.}

\item{int.method}{See \code{\link{calculate_ps}} for more details.}

\item{export.width}{A \code{numeric (double)} value specifying the width of the graph in inches. Only valid if \code{export.result = TRUE}. See \code{\link[ggplot2]{ggsave}} function for more details. The \code{export.wodth = TRUE} argument will be \code{10} by default.}

\item{export.height}{A \code{numeric (double)} value specifying the height of the graph in inches. Only valid if \code{export.result = TRUE}. See \code{\link[ggplot2]{ggsave}} function for more details. The \code{export.height} argument will be \code{10} by default.}

\item{...}{Other arguments passed on to the pollen season calculation as specified in \code{\link{calculate_ps}} function.}
}
\value{
This function returns different results: \cr
\itemize{
\item Graphical resume of the Quality Control results showing the seasons of each pollen type and their quality (the risk assumed if they are included in further studies). The legend indicates the number of filter that have been unsuccessfully passed for each case. Object of class \code{\link[ggplot2]{ggplot}}. For graphical customization, see \code{\link[ggplot2]{ggplot}} function.
\item \code{data.frame} named \code{"QualityControl"} with \code{logical} values indicating for each pollen type and season. If \code{TRUE}, the filter has been successfully passed for this case. If FALSE, this case does not fit the minimal requirements of this filter.
\item If \code{export.result = TRUE}, the graphical resume and a \code{data.frame} will be exported. The graphical resume will be exported with the file extension specified with \code{export.format} argument The \code{data.frame} will be exported as xlsx file within the "table_AeRobiology" folder including the main parameters of the pollen season with regard to phenology and pollen intensity as:
\itemize{
   \item \strong{type}: pollen type
   \item \strong{seasons}: year of the beginning of the season
   \item \strong{st.dt}: start_date (date)
   \item \strong{st.jd}: start_date (day of the year)
   \item \strong{en.dt}: end_date (date)
   \item \strong{en.jd}: end_date (day of the year)
   \item \strong{ln.ps}: length of the season
   \item \strong{sm.tt}: total sum
   \item \strong{sm.ps}: pollen integral
   \item \strong{pk.val}: peak value
   \item \strong{pk.dt}: peak_date (date)
   \item \strong{pk.jd}: peak_date (day of year)
   \item \strong{ln.prpk}: length of the pre_peak period
   \item \strong{sm.prpk}: pollen integral of the pre_peak period
   \item \strong{ln.pspk}: length of the post_peak period
   \item \strong{sm.pspk}: pollen integral of the post_peak period
   \item \strong{daysth}: number of days with more than 100 pollen grains
   \item \strong{st.dt.hs}: start_date of the High pollen season (date, only for \code{clinical} method)
   \item \strong{st.jd.hs}: start_date of the High pollen season (day of the year, only for \code{clinical} method)
   \item \strong{en.dt.hs}: end_date of the High pollen season (date, only for \code{clinical} method)
   \item \strong{en.jd.hs}: end_date of the High pollen season (day of the year, only for \code{clinical} method)
}
}
}
\description{
Function to check the quality of an historical database of several pollen types.
}
\details{
Quality control is a relevant topic for aerobiology (Oteros et al., 2013). This function is another approach to improve the quality control management in the field. \cr\code{qualitycontrol} function checks the quality of the pollen data of each pollen type and season. The filters applied by the function are: \cr
\itemize{
\item If the main pollen season (Galan et al., 2017) cannot be calculated according to \code{\link{calculate_ps}} function minimal requirements (lack of data for these pollen type and year). Filter named \code{"Complete"} in the \code{"QualityControl"} \code{data.frame}.
\item If the start, end or peak date of the main pollen season has been interpolated or a day near to it (number of days specified by \code{int.window} argument). If a day near to these dates is missing, the selected date could not be the right one. Filters named \code{"Start"}, \code{"Peak"} and \code{"End"} in the \code{"QualityControl"} \code{data.frame}.
\item The percentage of missing data inside the main pollen season. It calculates the number of days which have been interpolated by the algorithm and their percentage inside the main pollen season. If a high percentage of the main pollen season has been interpolated, the information of these season could not be reliable. Filter named \code{"Comp.MPS"} in the \code{"QualityControl"} \code{data.frame}.
}
}
\examples{
data("munich")
qualitycontrol(munich[,c(1:4)], export.result = FALSE)
}
\references{
Galan, C., Ariatti, A., Bonini, M., Clot, B., Crouzy, B., Dahl, A., Fernandez_Gonzalez, D., Frenguelli, G., Gehrig, R., Isard, S., Levetin, E., Li, D.W., Mandrioli, P., Rogers, C.A., Thibaudon, M., Sauliene, I., Skjoth, C., Smith, M., Sofiev, M., 2017. Recommended terminology for aerobiological studies. Aerobiologia (Bologna). 293_295.

Oteros, J., Galan, C., Alcazar, P., & Dominguez_Vilches, E. (2013). Quality control in bio_monitoring networks, Spanish Aerobiology Network. Science of the Total Environment, 443, 559_565.
}
\seealso{
\code{\link{calculate_ps}}, \code{\link{interpollen}}, \code{\link[ggplot2]{ggplot}}, \code{\link[ggplot2]{ggsave}}
}
