% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancer_gene_sites-data.R
\docType{data}
\name{cancer_gene_sites}
\alias{cancer_gene_sites}
\title{post-translational modification sites found in cancer genes}
\format{A data frame containing the following columns: chr, start, end, id
\describe{
    \item{chr}{autosomal chromosomes as chr1 to chr22 and sex chromosomes as chrX and chrY}
    \item{start}{the start position of the site in base 0 coordinates (BED format)}
    \item{end}{the end position of the site in base 0 coordinates (BED format)}
    \item{id}{the site identifier - each site should contain only 1 segment and a unique id. If ids are duplicated, each segment of the site will be treated as an individual site. Sites can be coding or noncoding such as phosphosites of protein coding genes in genomic coordinates or transcription factor binding sites of active enhancers.}
}}
\source{
\href{https://www.biorxiv.org/content/early/2017/12/19/236802}{bioRxiv}
}
\usage{
data(cancer_gene_sites)
}
\description{
post-translational modification sites found in cancer genes
}
\examples{
data(cancer_gene_sites)
\donttest{
data(cll_mutations)
data(cancer_genes)
ActiveDriverWGS(mutations = cll_mutations, elements = cancer_genes, sites = cancer_gene_sites)
}
}
\references{
Wadi, Lina, et al. "Candidate cancer driver mutations in super-enhancers and long-range chromatin interaction networks." bioRxiv (2017): 236802.
(\href{https://www.biorxiv.org/content/early/2017/12/19/236802}{bioRxiv})
}
\keyword{datasets}
