#' Genotypic data for apple dataset
#'
#' Genotypic data on 247 apple clones (\emph{i.e.}, genotypes) with a total of
#' 2,828 SNP markers (coded as 0, 1, 2 and there are no missing records).
#' Dataset obtained from supplementary material in Kumar \emph{et al.} (2015).
#'
#' @docType data
#'
#' @usage geno.apple
#'
#' @format matrix
#'
#' @keywords datasets
#'
#' @references
#' Kumar S., Molloy C., Muñoz P., Daetwyler H., Chagné D., and Volz R. 2015.
#' Genome-enabled estimates of additive and nonadditive genetic variances and prediction
#' of apple phenotypes across environments. G3 Genes, Genomes, Genetics 5:2711-2718.
#'
#' @examples
#' geno.apple[1:5, 1:5]
#'
#' @name geno.apple
NULL
