% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_sites.R
\name{clean_site_index}
\alias{clean_site_index}
\title{Prepare and clean site index file}
\usage{
clean_site_index(
  site_index,
  name_aru_id = "aru_id",
  name_site_id = "site_id",
  name_date_time = "date",
  name_coords = c("longitude", "latitude"),
  name_extra = NULL,
  resolve_overlaps = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{site_index}{(Spatial) Data frame or file path. Site index data
to clean. If file path, must be to a local csv or xlsx file.}

\item{name_aru_id}{Character. Name of the column that contains ARU ids.
Default \code{"aru_id"}.}

\item{name_site_id}{Character. Name of the column that contains site ids.
Default \code{"site_id"}.}

\item{name_date_time}{Character. Column name that contains dates or
date/times. Can be vector of two names if there are both 'start' and 'end'
columns. Can be \code{NULL} to ignore dates. Default \code{"date"}.}

\item{name_coords}{Character. Column names that contain longitude and
latitude (in that order). Ignored if \code{site_index} is spatial. Default
\code{c("longitude", "latitude")}}

\item{name_extra}{Character. Column names for extra data to include. If a named
vector, will rename the columns (see examples). Default \code{NULL}.}

\item{resolve_overlaps}{Logical. Whether or not to resolve date overlaps by
shifting the start/end dates to noon (default \code{TRUE}). This assumes that
ARUs are generally \emph{not} deployed/removed at midnight (the official
start/end of a day) and so noon is used as an approximation for when an ARU
was deployed or removed. If possible, use specific deployment times to
avoid this issue.}

\item{quiet}{Logical. Whether to suppress progress messages and other
non-essential updates.}
}
\value{
Standardized site index data frame
}
\description{
A site index file contains information on when specific ARUs were deployed
where. This function cleans a file (csv, xlsx) or data frame in preparation
for adding these details to the output of \code{clean_metadata()}. It can be used
to specify missing information according to date, such as GPS lon/lats and
site ids.
}
\details{
Note that times are assumed to be in 'local' time and a timezone isn't used
(and is removed if present, replaced with UTC). This allows sites
from different timezones to be processed at the same time.
}
\examples{

s <- clean_site_index(example_sites,
  name_aru_id = "ARU",
  name_site_id = "Sites",
  name_date_time = c("Date_set_out", "Date_removed"),
  name_coords = c("lon", "lat")
)

s <- clean_site_index(example_sites,
  name_aru_id = "ARU",
  name_site_id = "Sites",
  name_date_time = c("Date_set_out", "Date_removed"),
  name_coords = c("lon", "lat"),
  name_extra = c("plot" = "Plots")
)

# Without dates
eg <- dplyr::select(example_sites, -Date_set_out, -Date_removed)
s <- clean_site_index(eg,
  name_aru_id = "ARU",
  name_site_id = "Sites",
  name_date_time = NULL,
  name_coords = c("lon", "lat"),
  name_extra = c("plot" = "Plots")
)

}
