### Simulating direct observation procedures for single-case studies

A common problem when designing a single-case study is determining how to measure the target outcome. For measuring a behavior through direct observation, you might need to answer the following questions:

* What recording system should I use?
* For interval recording systems, how long should the intervals be?
* How long do I need to observe during each session?
* How many sessions will I need to achieve stability in each phase?

The ARPsimulator is a tool for helping you make more principled decisions about these questions. The tool generates __simulated__ behavioral observation data using a realistic statistical model, called the __Alternating Renewal Process__, which allows you to __experiment__ and test out different measurement strategies before collecting data on real live behaviors in the field. The simulation results are displayed in a __single-case graph__, just as you would see in a published article (though of course, the data are only hypothetical). Alternately, the results can be displayed as a plot of the distribution of __effect sizes__ that could be observed in the study. 

In order to use the tool, you'll need to make some initial guesses about the characteristics of the behavior and how it might change in response to treatment. You'll also need to know what type of study you plan to conduct (i.e., a multiple baseline design or a treatment reversal design). The remainder of this guide will walk you through how to use the tool.
