% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lr.R
\name{plot_lr}
\alias{plot_lr}
\title{Create plot for the long-run (cointegrating) equation}
\usage{
plot_lr(
  object,
  coint_eq,
  facets = FALSE,
  show_fitted = FALSE,
  show.legend = FALSE,
  xlab = "Time",
  ...
)
}
\arguments{
\item{object}{An object of \code{\link[base]{class}} `ardl`.}

\item{coint_eq}{The objected returned from \code{\link{coint_eq}}.}

\item{facets}{A logical indicating whether the long-run relationship appears
in a separate plot. Default is FALSE.}

\item{show_fitted}{A logical indicating whether the fitted values are shown.
Default is FALSE.}

\item{show.legend}{A logical indicating whether the legend is shown.
Default is FALSE.}

\item{xlab}{Name displayed at the x axis. Default is "Time".}

\item{...}{Currently unused argument.}
}
\value{
\code{plot_lr} returns a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Creates a plot for the long-run relationship in comparison with the dependent
variable, and the fitted values of the model. This is a basic
\code{\link[ggplot2]{ggplot}} with a few customizable parameters.
}
\examples{
ardl_3132 <- ardl(LRM ~ LRY + IBO + IDE, data = denmark, order = c(3,1,3,2))
ce2 <- coint_eq(ardl_3132, case = 2)

plot_lr(ardl_3132, coint_eq = ce2)

## Compare fitted values and place long-run relationship separately ----

ce3 <- coint_eq(ardl_3132, case = 3)
plot_lr(ardl_3132, coint_eq = ce3, facets = TRUE, show_fitted = TRUE,
        show.legend = TRUE)

}
\seealso{
\code{\link{coint_eq}}
}
\author{
Kleanthis Natsiopoulos, \email{klnatsio@gmail.com}
}
\keyword{iplots}
