% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APpolygonize.R
\name{APpolygonize}
\alias{APpolygonize}
\title{AP Polygonize}
\usage{
APpolygonize(inRaster, OSGeoPath = "C:\\\\OSGeo4W64", connectivity = 4)
}
\arguments{
\item{inRaster}{a RasterLayer or a path to a raster file}

\item{OSGeoPath}{character. Path to the OSGeo4W installation directory}

\item{connectivity}{numeric. Can be either set to 4 (rook's case) or 8 (queen's case)}
}
\value{
SpatialPolygonsDataFrame
}
\description{
This function uses the \emph{gdal_polygonize.py} GDAL utility. Its implementation
was adapted from the solution developed by John Baumgartner and Francisco Rodriguez-Sanchez.
}
\details{
This function needs OSGeo4W to be installed. The OSGeo4W installation path,
set to 'C:\\OSGeo4W64' by default, will then be used to find the \emph{OSGeo4W.bat} and \emph{gdal_polygonize.py}
files. Python must be installed in order to run \emph{gdal_polygonize.py}.
}
\seealso{
\itemize{
\item GDAL: \url{http://www.gdal.org/}
\item OSGeo4W download page: \url{https://trac.osgeo.org/osgeo4w/}
\item John Baumgartner's blog post on \emph{gdal_polygonize}: \url{https://johnbaumgartner.wordpress.com/2012/07/26/getting-rasters-into-shape-from-r/}
}
}

