% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{WHONET}
\alias{WHONET}
\title{Data set with 500 isolates - WHONET example}
\format{A \code{\link{data.frame}} with 500 observations and 53 variables:
\describe{
  \item{\code{Identification number}}{ID of the sample}
  \item{\code{Specimen number}}{ID of the specimen}
  \item{\code{Organism}}{Name of the microorganism. Before analysis, you should transform this to a valid microbial class, using \code{\link{as.mo}}.}
  \item{\code{Country}}{Country of origin}
  \item{\code{Laboratory}}{Name of laboratory}
  \item{\code{Last name}}{Last name of patient}
  \item{\code{First name}}{Initial of patient}
  \item{\code{Sex}}{Gender of patient}
  \item{\code{Age}}{Age of patient}
  \item{\code{Age category}}{Age group, can also be looked up using \code{\link{age_groups}}}
  \item{\code{Date of admission}}{Date of hospital admission}
  \item{\code{Specimen date}}{Date when specimen was received at laboratory}
  \item{\code{Specimen type}}{Specimen type or group}
  \item{\code{Specimen type (Numeric)}}{Translation of \code{"Specimen type"}}
  \item{\code{Reason}}{Reason of request with Differential Diagnosis}
  \item{\code{Isolate number}}{ID of isolate}
  \item{\code{Organism type}}{Type of microorganism, can also be looked up using \code{\link{mo_type}}}
  \item{\code{Serotype}}{Serotype of microorganism}
  \item{\code{Beta-lactamase}}{Microorganism produces beta-lactamase?}
  \item{\code{ESBL}}{Microorganism produces extended spectrum beta-lactamase?}
  \item{\code{Carbapenemase}}{Microorganism produces carbapenemase?}
  \item{\code{MRSA screening test}}{Microorganism is possible MRSA?}
  \item{\code{Inducible clindamycin resistance}}{Clindamycin can be induced?}
  \item{\code{Comment}}{Other comments}
  \item{\code{Date of data entry}}{Date this data was entered in WHONET}
  \item{\code{AMP_ND10:CIP_EE}}{27 different antibiotics. You can lookup the abbreviatons in the \code{\link{antibiotics}} data set, or use e.g. \code{\link{atc_name}("AMP")} to get the official name immediately. Before analysis, you should transform this to a valid antibiotic class, using \code{\link{as.rsi}}.}
}}
\usage{
WHONET
}
\description{
This example data set has the exact same structure as an export file from WHONET. Such files can be used with this package, as this example data set shows. The data itself was based on our \code{\link{septic_patients}} data set.
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a comprehensive tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\keyword{datasets}
